ad_page_contract {
    Configure the portal package's interaction with the subsite package in the 'ole
    look and feel department.
} {
}

ad_form -name configure-subsite-integration -form {
    {ReplaceSubsiteMasterTemplate:boolean(radio)
        {options {{Yes 1} {No 0}}}
        {label "Replace parent subsite master template?"}
    }
    {PortalIndexPage:boolean(radio)
        {options {{Yes 1} {No 0}}}
        {label "Should the parent subsite serve the portal package as its index page?"}
    }
} -on_request {
    set ReplaceSubsiteMasterTemplate 0
    set PortalIndexPage 0
    ad_set_form_values ReplaceSubsiteMasterTemplate PortalIndexPage
} -validate {
    {PortalIndexPage
        { !($ReplaceSubsiteMasterTemplate && $PortalIndexPage) }
        "You can only say \"Yes\" to one of these options."
    }
} -on_submit {
    if { $ReplaceSubsiteMasterTemplate } {
        parameter::set_value \
            -parameter DefaultMaster \
            -package_id [ad_conn subsite_id] \
            -value /packages/portal/lib/master
    }
    if { $PortalIndexPage } {
        parameter::set_value \
            -parameter IndexRedirectUrl \
            -package_id [ad_conn subsite_id] \
            -value [ad_conn package_url]
    }
    template::wizard::forward
}

template::wizard::submit configure-subsite-integration -buttons {back next}
