ad_page_contract {

    Generate a list of applications that have supporting portlets that have not
    yet been added to this portal package instance.  The user's returned to the
    current page after installing the select application(s).

    @author Don Baccus (dhogaza@pacifier.com)
    @creation-date 
    @cvs-id $Id: add-applications.tcl,v 1.2 2004/03/13 00:40:26 donb Exp $

} { }

set package_id [ad_conn package_id]
set return_url [ad_conn url]?[ad_conn query]

db_multirow -extend {add_url} applications get_applications {} {
    set add_url [export_vars -base add-applications-2 { application return_url }]
}

set wizard_p [template::wizard::exists]

# If we're in the wizard and have no applications just skip to the next step.

if { $wizard_p && ${applications:rowcount} == 0 } {
    rp_form_put wizard_submit_next wizard_submit_next
    template::wizard::forward
}

# Build the list-builder list.

template::list::create \
    -name applications \
    -multirow applications \
    -key application \
    -bulk_actions {
        "Add checked applications" "add-applications-2" "Add checked applications"
    } \
    -bulk_action_export_vars {
        application return_url
    } \
    -elements {
        application {
            label "Application"
        }
        add {
            label Add
            link_url_col add_url
            link_html { title "Add single application" }
            display_template {Add}
        }
    }

# Now, if we're in the template wizard, generate the wizard form and buttons.
 
if { $wizard_p } {

    ad_form -name add-applications -form {
        foo:text(hidden),optional
    } -on_submit {
        template::wizard::forward
    }

    template::wizard::submit add-applications -buttons {back next}
}

ad_return_template
