ad_page_contract { 
    Search user data

    @author Jeff Davis (davis@xarg.net)
} { 
    {page:integer,optional 0}
    {search:trim new}
}

# this script can be called three ways:
# 1. from within a community - should search only that community
# 2. from the user's control panel, help page and personal configuration 
#    portlet - searches all students, with suppression
# 3. from /profile/manage - searches all students and requires admin privs, 
#    so no suppression
#
# the presence of community_id is enough for us to know what we're doing,
# because it can't be removed by URL surgery

set admin_p [permission::permission_p -party_id [ad_conn user_id] -object_id [apm_package_id_from_key photobook] -privilege admin]
set community_id [dotlrn_community::get_community_id]

if { [exists_and_not_null community_id] } {
  set sitewide_p 0
} else {
  set sitewide_p 1
}

# Complicated state management 
# 

if { $sitewide_p } {
  set referer search
} else {
  set referer member-search
}
set users {}
set mode thumbnail

if {!$admin_p} { 
    set suppress 1
} else { 
    set suppress 0
}

set sql {}

# how many users per page 
set size 10
        
proc __like {str} { 
    # insert wildcard chars between each word, for slightly
    # better search results
    return "%[string tolower [join [split $str] %]]%"
}

set form_data {
    section { -section Personal }

    admin { q_institute_id:text 
        {label "Institute ID"}
        {html {size 20 maxlength 20}}
    } 

    all { q_name:text 
        {label "Name"}
        {html {size 60 maxlength 60}}
    } 

    all { q_email:text
        {label "E-mail"}
        {html {size 60 maxlength 60}}
    }

    all { q_origin:text(select)
        {options {[phb::country_options]}}
        {label "Country of Origin"}
    }

    all { q_citizenship:text(select)
        {label "Country of Citizenship"}
        {options {[phb::country_options]}}   
    }

    admin { q_gender:text(select)
        {label "Gender"}
        {options {[phb::options -key gender]}}   
    }

    admin { q_birthdate:date,to_sql(linear_date),from_sql(linear_date_no_time)
        {label "Date of Birth"}
    }

    admin { q_ethnicity:text(select)
        {options {[phb::options -key ethnicity]}}   
        {label "Ethnicity"}
    }

    all { q_partner:text 
        {label "Spouse/Partner"}
        {html {size 60 maxlength 60}}
    }

    admin { q_child:text 
        {label "Child"}
        {html {size 60 maxlength 60}}
    }

    admin { q_child_born:text(select)
        {options {[phb::year_options -start 0 -end -30]}}
        {label "Child born"}
    }

    all { q_language:text 
        {label "Language"}
        {html {size 60 maxlength 60}}
    }

    all { q_outside_interest:text 
        {label "Outside Interests"}
        {html {size 60 maxlength 60}}
    }

    all { q_favorite:text 
        {label "Favorites"}
        {html {size 60 maxlength 60}}
    }

    section { -section Employment }

    all { q_employment:text 
        {label "Employment"}
        {html {size 60 maxlength 60}}
    }

    section { -section Education }

    all { q_program:text(select)
        {options {[phb::options -key program]}}   
        {label "Program"}
    }

    all { q_class_year:text(select) 
        {options {[phb::year_options -start -5 -end 10]}}
        {label "Class Year"}
    }

    all { q_concentration:text(select) 
        {options {[concat [phb::options -key concentration_ug ] [phb::options -key concentration_phd]]}}
        {label "Concentration"}
    }

    admin { q_grad_range_exp:text(select) 
        {options {[phb::year_options -start -1 -end 10]}}
        {label "Graduation (expected)"}
    }

    admin { q_grad_range_pref:text(select)
        {label "Graduation (prefered)"}
        {options {[phb::year_options -start -1 -end 10]}}
    }

    all { q_academic_interest:text 
        {label "Academic Interests"}
        {html {size 60 maxlength 60}}
    }

    all { q_university:text(select)
        {options {[phb::options -key university]}}
        {label "School/University"}
    }

    all { q_degree:text(select)
        {options {[phb::options -key degree]}}   
        {label "Degree"}
    }
    
    all { q_major:text(select)
        {options {[phb::options -key field -postfix {{Other Other}}]}}   
        {label "Major"}
    }
    
    admin { q_granted:text(select) 
        {options {[phb::year_options -start 0 -end -30]}}
        {label "Year granted"}
    }

    section { -section Address }

    all { q_living_group:text(select)
        {label "Living group"}
        {options {[phb::options -key livinggroup]}}   
    }

    all { q_address:text 
        {label "Address"}
        {html {size 60 maxlength 60}}
    }

    all { q_phonenumber:text
        {label "Phone number"}
        {html {size 20 maxlength 20}}
    }

    all { q_hometown:text 
        {label "Hometown Address"}
        {html {size 60 maxlength 60}}
    }

    all { q_hometown_country:text(select)
        {options {[phb::country_options]}}   
        {label "Hometown Country"}
    }
    
}

if {$page > 0} {
    # we are displaying a particular page; just get the search properties
    set users [ad_get_client_property photobook search_results]

    if {[expr {($page - 1)*$size}] >= [llength $users]} {
        set page 0
        set search edit
    } 
}

if {$page < 1 } { 
    # search is new or edit 

    if {[string equal $search edit]} { 
        array set prior_search [ad_get_client_property photobook search_query]
    } 
    set form [list]
    foreach {type data} $form_data {
        set var_with_options [lindex $data 0]
	set rest_of_data [lrange $data 1 end]
	set colon_index [string first ":" $var_with_options]
	if {$colon_index > -1} {
	    set var $var_with_options
	} else {
	    set var [string range $var_with_options 0 [expr $colon_index - 1]]
	}
        if {[string equal $type section] 
            || [string equal $type all]
            || $admin_p
        } { 
            if {[info exists prior_search($var)]} { 
                lappend rest_of_data [list value $prior_search($var)]
            }
            if {![string match "section" $type]} { 
	        if {$colon_index > -1} {
	  	    append var_with_options ",optional"
	        } else {
		    append var_with_options ":optional"
	        }
            }
            lappend form [concat $var_with_options $rest_of_data] 

        } elseif {[string equal $type admin] 
                  && !$admin_p } { 
            set $var {}
        } 
    }    

    ad_form -name search -form $form -on_submit { 
        # Construct the query for the search
        # 
        
        # Do we need the top level priv field?
        set priv 0
        if {!$admin_p} {
            foreach {type data} $form_data {
                set var [string range [lindex $data 0] 0 [expr [string first : [lindex $data 0]] - 1]]
                if {![string equal $type section] 
                    && [info exists $var]
                    && ![string is space [set $var]]
                    && [lsearch {q_email q_name} $var] == -1 } { 
                    set priv 1
                    break 
                } 
            } 
        } 

        if { $sitewide_p } {
            set sql "SELECT p.user_id, '' as role, p.last_name
            FROM phb_personx p, cr_items i
            WHERE p.item_id = i.item_id 
              and p.revision_id = i.live_revision\n"
        } else {
            set sql "SELECT p.user_id, '' as role, p.last_name
            FROM phb_personx p, cr_items i, dotlrn_member_rels_approved r
            WHERE p.item_id = i.item_id 
              and p.revision_id = i.live_revision
              and r.community_id = :community_id
              and p.user_id = r.user_id\n"
        }

        if {$priv} {
            append sql "and p.priv = 0\n"
        } 

        if { ![string is space $q_institute_id]} { 
            if {!$suppress} { 
                append sql "and p.institute_id like '[__like $q_institute_id]'\n"
            }
        }

        if { ![string is space $q_name] } { 
            set q_name_like [__like $q_name]
            if {!$suppress} { 
                append sql "and lower(p.salutation || ' ' || p.first_name || ' ' || p.middle_name || ' ' || p.last_name || ' ' || p.preferred_name || ' ' || p.former_name) like :q_name_like\n"
            } else { 
                append sql "and lower(p.salutation || ' ' || p.first_name || ' ' || p.middle_name || ' ' || p.last_name || ' ' || (case when p.priv_preferred_name = 0 and p.priv = 0 then p.preferred_name else '' end) || ' ' || (case when p.priv_former_name = 0 and p.priv = 0 then p.former_name else '' end)) like :q_name_like\n"
            }
        } 
        
        if { ![string is space $q_email] } { 
            set q_email_like [__like $q_email]
            append sql "and ( 
  exists (select 1 from parties where party_id = p.user_id and lower(email) like :q_email_like)
  or exists (select 1 from sloan_email where sloan_email.user_id = p.user_id and (alias like :q_email_like or outside like :q_email_like or efl like :q_email_like )) )\n"
        }
        
        if { ![string is space $q_origin]} { 
            if {!$suppress} { 
                append sql "and p.origin = :q_origin\n"
            } else { 
                append sql "and p.origin = :q_origin and priv_origin = 0\n"
            } 
        } 

        if { ![string is space $q_citizenship]} { 
            if {!$suppress} { 
                append sql "and p.citizenship = :q_citizenship\n"
            } else { 
                append sql "and p.citizenship = :q_citizenship and priv_citizenship = 0\n"
            } 
        } 

        if { ![string is space $q_gender] } { 
            if {!$suppress} { 
                append sql "and p.gender = :q_gender\n"
            } else { 
                append sql "and p.gender = :q_gender and priv_gender = 0\n"
            }
        } 
        
        if { ![string is space $q_birthdate] } { 
            if {!$suppress} { 
                append sql "and p.birthdate = to_date(:q_birthdate, 'YYYY MM DD HH24 MI SS')\n"
            } else { 
                append sql "and p.birthdate = to_date(:q_birthdate, 'YYYY MM DD HH24 MI SS') and priv_birthdate = 0\n"
            }
        } 
        
        if { ![string is space $q_ethnicity] } { 
            if {!$suppress} { 
                append sql "and p.ethnicity = :q_ethnicity\n"
            } else { 
                append sql "and p.ethnicity = :q_ethnicity and priv_ethnicity = 0\n"
            } 
        }

        if { ![string is space $q_partner] } { 
            set q_partner_like [__like $q_partner]
            if {!$suppress} { 
                append sql "and lower(p.partner_firstname || ' ' || partner_lastname) like :q_partner_like\n"
            } else { 
                append sql "and p.priv_partner = 0 and lower(p.partner_firstname || ' ' || partner_lastname) like :q_partner_like\n"
            } 
        }
        if { ![string is space $q_child] } { 
            set q_child_like [__like $q_child]
            append sql "and ( 
 lower(p.child_1) like :q_child_like
 or lower(p.child_2) like :q_child_like
 or lower(p.child_3) like :q_child_like
 or lower(p.child_4) like :q_child_like
 or lower(p.child_5) like :q_child_like )\n"
            if {$suppress} { 
                append sql "and p.priv_child = 0\n"
            } 
        }

        if { ![string is space $q_child_born] } { 
            append sql "and ( 
 p.child_born_1 = :q_child_born
 or p.child_born_2 = :q_child_born
 or p.child_born_3 = :q_child_born
 or p.child_born_4 = :q_child_born
 or p.child_born_5 = :q_child_born )\n"
            if {$suppress} { 
                append sql "and p.priv_child = 0\n"
            } 
        }
        
        if { ![string is space $q_language] } { 
            append sql "and ( 
 lower(p.language_1) = lower(:q_language)
 or lower(p.language_2) = lower(:q_language)
 or lower(p.language_3) = lower(:q_language) )\n"
            if {$suppress} { 
                append sql "and p.priv_language = 0\n"
            } 
        }

        if { ![string is space $q_outside_interest] } { 
            set q_outside_interest_like [__like $q_outside_interest]
            append sql "and ( 
 lower(p.outside_interest_1) like :q_outside_interest_like
 or lower(p.outside_interest_2) like :q_outside_interest_like
 or lower(p.outside_interest_3) like :q_outside_interest_like )\n"
            if {$suppress} { 
                append sql "and p.priv_outside_interest = 0\n"
            } 

        }

        if { ![string is space $q_favorite] } { 
            set q_favorite_like [__like $q_favorite]
            if {!$suppress} { 
                append sql "and ( 
 lower(p.favorite_place) like :q_favorite_like
 or lower(p.favorite_book) like :q_favorite_like
 or lower(p.favorite_movie) like :q_favorite_like )\n"
            } else { 
                append sql "and ( 
 (case when p.priv_favorite_place = 0 then lower(p.favorite_place) else '' end) like :q_favorite_like
 or (case when p.priv_favorite_book = 0 then lower(p.favorite_book) else '' end) like :q_favorite_like
 or (case when p.priv_favorite_movie = 0 then lower(p.favorite_movie) else '' end) like :q_favorite_like)"
            }
        }

        if { ![string is space $q_employment]} { 
            set q_employment_like [__like $q_employment]
            if {!$suppress} {
                append sql "and ( 
   lower(p.past_employers) like :q_employment_like
   or lower(p.urop_1) like :q_employment_like
   or lower(p.urop_2) like :q_employment_like
   or exists (
     select 1 
     from phb_span emp, cr_items empi, cr_child_rels empr 
     where empr.relation_tag IN ('job_current','job_past','internship') 
       and empr.parent_id = p.item_id
       and empr.child_id = empi.item_id
       and empi.live_revision = emp.span_id 
       and lower (emp.institution || ' ' || emp.department || ' ' || emp.location) like :q_employment_like ) )\n"
            } else { 
                append sql "and ( 
   (case when p.priv_past_employers = 0 then lower(p.past_employers) else '' end) like :q_employment_like
   or (case when p.priv_urop = 0 then lower(p.urop_1) else '' end) like :q_employment_like
   or (case when p.priv_urop = 0 then lower(p.urop_2) else '' end) like :q_employment_like
   or exists (
     select 1 
     from phb_span emp, cr_items empi, cr_child_rels empr 
     where emp.priv = 0 
       and empr.relation_tag IN ('job_current','job_past','internship') 
       and empr.parent_id = p.item_id
       and empr.child_id = empi.item_id
       and empi.live_revision = emp.span_id 
       and lower (emp.institution || ' ' || emp.department || ' ' || emp.location) like :q_employment_like ) )
   and priv_employment = 0\n"
            } 
        }
        if { ![string is space $q_program]} { 
            append sql "and p.program = :q_program\n"
            if {$suppress} { 
                append sql "and p.priv_program = 0\n"
            } 
        } 

        if { ![string is space $q_class_year]} { 
            append sql "and p.class_year = :q_class_year\n"
            if {$suppress} { 
                append sql "and p.priv_class_year = 0\n"
            } 
        } 

        if { ![string is space $q_grad_range_exp]} { 
            append sql "and p.expected_graduation = :q_grad_range_exp\n"
        } 

        if { ![string is space $q_grad_range_pref]} { 
            append sql "and p.preferred_graduation = :q_grad_range_pref\n"
        } 
        
        if { ![string is space $q_concentration]} { 
            append sql "and (p.concentration_1 = :q_concentration or p.concentration_2 = :q_concentration)\n"
            if {$suppress} { 
                append sql "and p.priv_concentration = 0\n"
            } 
        } 

        if { ![string is space $q_academic_interest] } { 
            set q_academic_interest_like [__like $q_academic_interest]
            append sql "and ( 
 lower(p.academic_interest_1) like :q_academic_interest_like
 or lower(p.academic_interest_2) like :q_academic_interest_like
 or lower(p.academic_interest_3) like :q_academic_interest_like )\n"
            if {$suppress} { 
                append sql "and p.priv_academic_interest = 0\n"
            } 
        }

        if { ! [string is space $q_university] 
             || ! [string is space $q_degree] 
             || ! [string is space $q_major]
             || ! [string is space $q_granted]} { 
            if {!$suppress} { 
                append sql "and exists (
     select 1 
     from phb_span ed, cr_items edi, cr_child_rels edr 
     where edr.relation_tag = 'degree'
       and edr.parent_id = p.item_id
       and edr.child_id = edi.item_id
       and edi.live_revision = ed.span_id\n"
                if { ! [string is space $q_university] } { 
                    set q_university_like [__like $q_university]
                    append sql "and lower(ed.institution) like :q_university_like\n" 
                } 
                if { ! [string is space $q_degree] } { 
                    append sql "and ed.relation = :q_degree\n" 
                } 
                if { ! [string is space $q_major] } { 
                    append sql "and ed.department = :q_major\n" 
                } 
                if { ! [string is space $q_granted] } { 
                    append sql "and to_char(ed.ended,'YYYY') = :q_granted\n" 
                } 
                append sql ")\n"
            } else { 
                append sql "and exists (
     select 1 
     from phb_span ed, cr_items edi, cr_child_rels edr 
     where ed.priv = 0 
       and edr.relation_tag = 'degree'
       and edr.parent_id = p.item_id
       and edr.child_id = edi.item_id
       and edi.live_revision = ed.span_id\n"
                if { ! [string is space $q_university] } { 
                    set q_university_like [__like $q_university]
                    append sql "and lower(ed.institution) like :q_university_like\n" 
                } 
                if { ! [string is space $q_degree] } { 
                    append sql "and ed.relation = :q_degree\n" 
                } 
                if { ! [string is space $q_major] } { 
                    append sql "and ed.department = :q_major\n" 
                } 
                if { ! [string is space $q_granted] } { 
                    append sql "and to_char(ed.ended,'YYYY') = :q_granted\n" 
                } 
                append sql ")\n"
            }
        }

        if { ![string is space $q_living_group]} { 
            append sql "and p.living_group = :q_living_group\n"
            if {$suppress} { 
                append sql "and p.priv_living_group = 0\n"
            }
        } 
        
        if { ![string is space $q_address] } { 
            set q_address_like [__like $q_address]        
            if {!$suppress} { 
                append sql "and exists (
     select 1 
     from phb_address cad, cr_items cadi, cr_child_rels cadr 
     where cadr.relation_tag = 'address'
       and cadr.parent_id = p.item_id
       and cadr.child_id = cadi.item_id
       and cadi.live_revision = cad.address_id\n"
                
                append sql "and lower(cad.address_1 || ' '|| cad.address_2 || ' '|| cad.address_3 || ' ' || cad.city || ' ' || cad.state || ' ' || cad.postcode || ' ' || cad.country) like :q_address_like\n"
                append sql ")\n"
            } else { 
                append sql "and p.priv_address = 0 
 and exists (
     select 1 
     from phb_address cad, cr_items cadi, cr_child_rels cadr 
     where cad.priv = 0 
       and cadr.relation_tag = 'address'
       and cadr.parent_id = p.item_id
       and cadr.child_id = cadi.item_id
       and cadi.live_revision = cad.address_id\n"
                
                append sql "and lower((case when cad.priv_address = 0 then cad.address_1 || ' '|| cad.address_2 || ' '|| cad.address_3 || ' ' else '' end) || cad.city || ' ' || cad.state || ' ' || cad.postcode || ' ' || cad.country) like :q_address_like\n"
                append sql ")\n"
            }
        }
        
        if { ![string is space $q_hometown] } { 
            set q_hometown_like [__like $q_hometown]        
            if {!$suppress} { 
                append sql "and exists (
     select 1 
     from phb_address had, cr_items hadi, cr_child_rels hadr 
     where hadr.relation_tag = 'hometown'
       and hadr.parent_id = p.item_id
       and hadr.child_id = hadi.item_id
       and hadi.live_revision = had.address_id\n"
                
                append sql "and lower(had.address_1 || ' '|| had.address_2 || ' '|| had.address_3 || ' ' || had.city || ' ' || had.state || ' ' || had.postcode) like :q_hometown_like\n"
                append sql ")\n"
            } else { 
                append sql "and p.priv_address = 0 
 and exists (
     select 1 
     from phb_address had, cr_items hadi, cr_child_rels hadr 
     where had.priv = 0
       and hadr.relation_tag = 'hometown'
       and hadr.parent_id = p.item_id
       and hadr.child_id = hadi.item_id
       and hadi.live_revision = had.address_id\n"
                
                append sql "and lower(had.address_1 || ' '|| had.address_2 || ' '|| had.address_3 || ' ' || had.city || ' ' || had.state || ' ' || had.postcode) like :q_hometown_like\n"
                append sql ")\n"
            } 
        }

        if { ![string is space $q_hometown_country] } { 
            set q_hometown_country_like [__like $q_hometown_country]        
            if {!$suppress} { 
                append sql "and exists (
     select 1 
     from phb_address had, cr_items hadi, cr_child_rels hadr 
     where hadr.relation_tag = 'hometown'
       and hadr.parent_id = p.item_id
       and hadr.child_id = hadi.item_id
       and hadi.live_revision = had.address_id\n"
                
                append sql "and lower(had.country) like :q_hometown_country_like\n"
                append sql ")\n"
            } else { 
                append sql "and p.priv_address = 0 
 and exists (
     select 1 
     from phb_address had, cr_items hadi, cr_child_rels hadr 
     where had.priv = 0
       and hadr.relation_tag = 'hometown'
       and hadr.parent_id = p.item_id
       and hadr.child_id = hadi.item_id
       and hadi.live_revision = had.address_id\n"
                
                append sql "and lower(had.country) like :q_hometown_country_like\n"
                append sql ")\n"
            } 
        }

        if { ![string is space $q_phonenumber] } { 
            regsub -all {[^0-9]} $q_phonenumber {} q_phonenumber
            set q_phonenumber_like [__like $q_phonenumber]
            if {!$suppress} { 
                append sql "and exists (
     select 1 
     from phb_phone ph, cr_items phi, cr_child_rels phr 
     where phr.relation_tag IN ('home','mobile')
       and phr.parent_id = p.item_id
       and phr.child_id = phi.item_id
       and phi.live_revision = ph.phone_id
       and (ph.country_code || ' ' || ph.area_code || ph.phone_number || ' ' || ph.extension) like :q_phonenumber_like )\n"
            } else { 
                append sql "and p.priv_address = 0 
 and exists (
     select 1 
     from phb_phone ph, cr_items phi, cr_child_rels phr 
     where ph.priv = 0 
       and phr.relation_tag IN ('home','mobile')
       and phr.parent_id = p.item_id
       and phr.child_id = phi.item_id
       and phi.live_revision = ph.phone_id
       and (ph.country_code || ' ' || ph.area_code || ph.phone_number || ' ' || ph.extension) like :q_phonenumber_like )\n"
                
            }
        }


        append sql " order by lower(last_name),lower(first_name)"

        set users [db_list_of_lists foo $sql]

        ad_set_client_property -persistent f photobook search_results $users

        set query [list]
        foreach {type data} $form_data {
            set var [string range [lindex $data 0] 0 [expr [string first : [lindex $data 0]] - 1]]
            if {[info exists $var]} { 
                lappend query $var [set $var]
            } 
        } 

        ad_set_client_property -persistent f photobook search_query $query

        set page 1
    }
}

if {[llength $users] > 0} { 
    phb::pagination pages $users $size $page

    # Generate prev next links 
    # 
    if {$page > 1} { 
        set prev_page [expr $page - 1]
    } 

    if {[expr $page * $size] < [llength $users]} { 
        set next_page [expr $page + 1]
    } 
    
    # Pull out just the users we want to display
    # 
    set start [expr {($page - 1)*$size}]
    set end [expr $start + $size - 1]
    set users [lrange $users $start $end]
}

set sql [ad_quotehtml $sql]

if { $page } {
    set return_url "[ad_conn package_url]${referer}?page=$page"
    set return_page "Return to the search page"
} 
