ad_page_contract { 
    Privacy editing for a user.
    
    @author Jeff Davis (davis@xarg.net)
    @creation-date 15 Febuary 2003
    @cvs-id $Id: privacy.tcl,v 1.1 2003/11/03 20:10:56 janines Exp $
} { 
    {user_id:integer,optional {}}
} 

# Permissions and defaults.
set my_user_id [phb::dispatch -user_id $user_id]

# save user_id in _user_id so it does not get clobbered later.
if {[empty_string_p $user_id] || !$user_id} { 
    set user_id $my_user_id
}

# Check admin if editing another user.
if {![string equal $user_id $my_user_id]} { 
    append foo "permission::require_permission -party_id $my_user_id -object_id [ad_conn package_id] -permission admin"
} 

set submission [string equal privacy [ns_queryget form:id]]

# 
# Get the list of item ids for this user.
# 
set childlist [phb::users_items -user_ids $user_id]
array set children $childlist

if {[empty_string_p $children(phb_person.parent)]} { 
    ad_return_template privacy-missing-data
    return
}

#
# Pull out all the data for a user.
#

# build a list of the types.
#
foreach {tag val} $childlist { 
    set type [lindex [split $tag .] 0]
    if {![empty_string_p $val]} { 
        if {[info exists ids($type)]} {
            set ids($type) [concat $ids($type) $val]
        } else { 
            set ids($type) $val
        } 
    } 
} 

#
# actually pull out the data 
# 
foreach type [array name ids] { 
    if {![string equal image $type] && [llength $ids($type)]} {
        db_multirow -local $type get " 
            SELECT t.item_id, t.revision_id, t.name, [phb::private_flags_sql -prefix t $type]
              FROM ${type}x t, cr_items i 
             WHERE t.item_id in ([join $ids($type) ", "]) 
               and t.revision_id = i.latest_revision"
    } 
}

#
# Start building the form
#

# topform is ALL and per section privacy, form is all the rest.
set form [list]

if {!$submission} { 
    set default [template::multirow get phb_person 1 priv] 
} else { 
    set default 0
}
set topform {{-section {Suppression settings}}}
lappend topform [phb::privacy_widget $children(phb_person.parent)_priv "All" $default]
                    
lappend topform {-section Categories}


#
# Here we walk the categories creating the data for the user...
#
foreach {_sect_key _section _rels} { 
    personal {All personal data} phb_person.parent
    address {All address data} {phb_address.address phb_phone.home phb_phone.mobile phb_address.hometown}
    employment {All employment data} {phb_span.internship phb_span.job_current phb_span.job_past} 
    education {All education data} {phb_span.degree}
} { 
    set _map_$_sect_key {}
    set default 0
    if {!$submission} { 
        set default [template::multirow get phb_person 1 priv_$_sect_key] 
    } 
    lappend topform [phb::privacy_widget $children(phb_person.parent)_priv_$_sect_key \
                         $_section $default]
                         

    lappend form [list -section $_section]

    # for each relation in a section 
    foreach _child $_rels { 
        
        set _items $children($_child)
        set _type [lindex [split $_child .] 0]
        set _rel [lindex [split $_child .] 1]

        # for each row in a given type check if it belongs to the
        # section and create widget for it.
        multirow foreach $_type { 
            if {[lsearch $_items $item_id] > -1} { 
                # map this item_id onto the section id map list.
                lappend _map_$_sect_key $item_id
                foreach _column [template::multirow columns $_type] { 
                    set default 0
                    if {!$submission} { 
                        set default [set $_column]
                    } 
                    set widget [phb::privacy_widget "${item_id}_$_column" \
                                    [phb::privacy_label $_column $_rel $name] \
                                    $default ]
                    if {![empty_string_p $widget]} { 
                        lappend form $widget
                    }
                } 
            }
        } 
    } 

} 




ad_form -name privacy -export { 
    user_id
} -form [concat $topform $form] -on_submit { 

    #
    # Build the update statements from the provided data 
    # 

    foreach type {person span phone address} { 

        multirow foreach phb_$type { 

            set upd_list {}

            foreach column [template::multirow columns phb_$type] { 
                if {[string match "priv*" $column]} { 
                    if { [info exists  ${item_id}_$column]
                         && ![string equal [set ${item_id}_$column] {}] } { 

                        lappend upd_list "$column = [set ${item_id}_$column]"  

                    } elseif { [template::element exists privacy ${item_id}_$column] } { 

                        lappend upd_list "$column = 0" 

                    } 
                } 
            } 
            if {[llength $upd_list]} { 
                db_dml update "update phb_$type set [join $upd_list ", "] where ${type}_id = (select latest_revision from cr_items where item_id = $item_id)"
            } 
        } 
    }

    ad_returnredirect .
    ad_script_abort
}
