ad_page_contract { 
    set a section privacy flag 

    @author Jeff Davis (davis@xarg.net)
    @creation-date 15 Febuary 2003
    @cvs-id $Id: privacy-set.tcl,v 1.1 2003/11/03 20:10:56 janines Exp $
} { 
    user_id:integer
    section:trim,notnull
    value:integer
    {return_url {}}
} 

set my_user_id [ad_maybe_redirect_for_registration]
if {[empty_string_p $user_id] || !$user_id} { 
    set user_id $my_user_id
} 

if {![string equal $user_id $my_user_id]} { 
    append foo "permission::require_permission -party_id $my_user_id -object_id [ad_conn package_id] -permission admin"
} 

set sections {address education personal employment all}
if {[lsearch $sections $section] == -1} { 
    ad_return_error "Invalid section $section" "Section must be one of address education personal employment or all"
    ad_script_abort
} 

# Create the update statement to make a particular section public or not.  
# We have to unset priv and set sections individually to do that.
#

# this convoluted bit just says: set the given section to value, set
# all other sections to priv unless priv is 0

foreach sec $sections {
    if {![string equal all $sec]} { 
        if {[string equal $sec $section] 
        } { 
            append set ",\npriv_$section = :value"
        } else {
            if {![string equal all $section] } {
                append set ",\npriv_$sec = (case when priv = 0 then priv_$sec else priv end)"
            } else { 
                append set ",\npriv_$sec = 0"
            } 
        } 
    } 
}

if {[string equal all $section]} { 
    set priv_all $value
} else { 
    set priv_all 0
} 

set key [phb::key $user_id]
set parent_id [phb::root_folder]

db_dml update_privacy "update phb_person set priv = :priv_all $set
where person_id = (select latest_revision from cr_items where name = :key and parent_id = :parent_id)"

if {[string equal $section all]} { 
    set section main
} 

if {[empty_string_p $return_url]} { 
    ad_returnredirect display/$user_id/$section
} else {     
    ad_returnredirect $return_url
} 
