ad_page_contract { 
    Display the privacy policy.

    If the user has not accepted the policy or
    has declined then display "accept" and "decline" buttons.

    @author Jeff Davis (davis@xarg.net)
    @creation-date 15 Febuary 2003
    @cvs-id $Id: privacy-policy.tcl,v 1.1 2003/11/03 20:10:56 janines Exp $
} { 
    accept:optional
    decline:optional
    {return_url ./}
}

# If there is no privacy policy simply redirect to the return url.

if {![phb::privacy_p]} { 
    ad_returnredirect $return_url
} 

set accept [info exists accept]
set decline [info exists decline]

set user_id [ad_conn user_id]


# We got an accept or decline so set state.
if {$user_id && ($accept || $decline)} { 
    if {$decline} { 
        set accepted f
    } else { 
        set accepted t
    }

    phb::privacy_set -user_id $user_id -accepted $accepted
    ad_returnredirect $return_url
    ad_script_abort
}

# Decide if we should prompt for acceptance of the privacy policy
set prompt 0
set previously_declined 0
set accepted_p [phb::privacy_accepted -user_id $user_id]
if {$user_id && ![string equal $accepted_p "t"]} { 
    set prompt 1
    if {[string equal $accepted_p "f"]} { 
        set previously_declined 1
    } 
}
