ad_page_contract { 
    Image upload for the given user.  Requires admin permission if not uploading
    your own photo.
} { 
    {user_id:integer {}}
    cancel:optional
}

if {[info exists cancel]} { 
    ad_returnredirect [phb::package_url]
}

set my_user_id [phb::dispatch -page edit -user_id $user_id]

if {[empty_string_p $user_id]} { 
    set user_id $my_user_id
} elseif {![string equal $user_id $my_user_id]} { 
    # PERM: Check the user has priv to upload an image for another user
    permission::require_permission -object_id [ad_conn package_id] -privilege admin
} 


set root_id [phb::root_folder]
set base [phb::key $user_id]
set name ${base}_portrait_base

if { [catch {  
        set parent_id [db_string parent "select item_id from cr_items where name = :base and parent_id = :root_id"]
        set item_id [db_string image "select item_id from cr_items where name = :name and parent_id = :parent_id" -default {}] 
        } err] } {
    ad_return_error Error "Invalid or uninitialized user"
    ad_script_abort
} 
    

if { [db_0or1row current_photo { 
    select image_revision_id, width, height, first_name, last_name from phb_portraits where relation_tag = 'portrait_small' and user_key = :base
} ] } {
    set image_url "[phb::package_url]image/$user_id/${first_name}_$last_name.jpg"
}
    

ad_form -name portrait -export user_id -form { 
    {content:file(file) 
        {label "Portrait file"}
        {html {size 50}}
    }
} -html { 
    enctype "multipart/form-data" 
} -on_submit { 
    if {[catch {set images [phb::generate_photos [ns_queryget content.tmpfile]]} errMsg]} { 
        template::element::set_error portrait content "Error parsing your image file.<br>Try again or contact the Profile administrator." 
	ns_log Error "JCD: convert error $errMsg"
    } else { 
        # Now we go through and create the image cr_revisions.
        phb::load_images $images $base $parent_id

        if {[string equal $user_id $my_user_id]} { 
            ad_returnredirect portrait
        } else { 
            ad_returnredirect "portrait?[export_vars -url user_id]"
        } 
    } 
} 

