ad_page_contract { 
    Delete a photo
} { 
    {user_id:integer {}}
    {return_url {}}
}

set my_user_id [phb::dispatch -user_id $user_id]

if {[empty_string_p $user_id]} { 
    set user_id $my_user_id
} elseif {![string equal $user_id $my_user_id]} { 
    # PERM: Check the user has admin 
    permission::require_permission -object_id [ad_conn package_id] -privilege admin
} 

set root_id [phb::root_folder]
set base [phb::key $user_id]
set name ${base}_portrait_base

if { [catch {  
    set parent_id [db_string parent "select item_id from cr_items where name = :base and parent_id = :root_id"]
} err] } {
    ad_return_error Error "No portrait exists to delete"
    ad_script_abort
} 
    
db_dml unlive {
    update cr_items set live_revision = null 
    where item_id in (
                      select child_id 
                      from cr_child_rels 
                      where relation_tag like 'portrait%' 
                      and parent_id = :parent_id)} 

if {[empty_string_p $return_url]} { 
    if {![string equal $my_user_id $user_id]} {
        ad_returnredirect portrait?user_id=$user_id
    } else { 
        ad_returnredirect portrait
    } 
} else { 
    ad_returnredirect $return_url
}    

