ad_page_contract { 
    A new user who has just come to the photobook for the first time
    has to create their sloan alias and EFL email address, as well as
    enter the data which will no longer be editable in the future.
    
    @author Jeff Davis (davis@xarg.net)
} { 
    {item_id:integer {}}
    {return_url:trim display/}
}

set user_id [phb::dispatch -page new]

# This is the record name for cr_items
set name [phb::key $user_id]

# cr item folder for this instance of photobook.
set parent_id [phb::root_folder]

set efl {}

if {[empty_string_p $item_id] 
    && [ db_0or1row current_data {
        select item_id, latest_revision
        from cr_items i, phb_person p
        where i.name = :name 
        and i.parent_id = :parent_id 
        and p.person_id = i.latest_revision
    } ]
    && [db_0or1row email {
        select efl, alias, outside from sloan_email where user_id = :user_id
    } ]
} { 
    # Is this users email or alias already defined 
    if {![string equal {} $efl]
        || ![string equal {} $alias]
    } { 
        ad_returnredirect "[phb::package_url]ae?form_type=a"
        ad_script_abort
    } 
} 

if {[empty_string_p $item_id]} {
    set item_id [db_nextval acs_object_id_seq]
} 

# Set up the necessary variables to create a content item.

if {![db_0or1row name {select email as outside, first_names, last_name from cc_users where user_id = :user_id}]} {
    ns_log Error "photobook/www/new: user_id given but not found in cc_users"         
    ad_return_error Error "User id $user_id does not exist"
    ad_script_abort
} 

ad_form -name new-user -export { 
    item_id
    parent_id
    name
    outside
    {content_type phb_person} 
    {content_method no_content}
    efl
    user_id
    return_url
} -form { 
    {first_name:text(text) 
        {label "First name"} 
        {html {size 60 maxsize 200}}
        {value {[lindex $first_names 0]}}
    }
    {middle_name:text(text) 
        {label "Middle names"} 
        {html {size 60 maxsize 200}}
        {value {[lrange $first_names 1 end]}}
        {optional}
    }
    {last_name:text(text) 
        {label "Last name"} 
        {html {size 60 maxsize 200}}
        {value $last_name} 
    }
    {alias:text(text)
        {label "Choose an email&nbsp;alias"} 
        {html {size 60 maxsize 200}}
        {optional}
    }
} -validate { 
    {alias {[regexp {^[A-Za-z0-9_]*$} [string trim $alias]]} {Your email alias may only contain letters, numbers, and "_".}}
    {alias {[string length [string trim $alias]]} {You must choose a Sloan alias.}}
    {alias {[string length [string trim $alias]] > 2} {You must choose an alias of at least 3 characters.}}
    {alias {[string length [string trim $alias]] < 21} {You must choose an alias of no more than 20 characters.}}
    {alias {[phb::email_available [string trim $alias] [ad_conn user_id]]} "The alias you chose is already in use.  Please choose another alias."}
} -on_submit {  

    template::element create new-user revision_id -datatype integer -widget hidden -value [db_nextval acs_object_id_seq]

    set alias [string tolower [string trim $alias]]
    db_transaction { 
        # Need to lock excl the email table here.

        phb::email_available $alias [ad_conn user_id]
        if {[empty_string_p $efl]} { 
            set efl [phb::get_sloan_efl $first_name $middle_name $last_name $user_id]
        } 

        # create the photobook user record.
        set id [content::new_item new-user]
        cr::item::set_latest_revision_live -item_id $id
        
        # create the email record
        db_dml create_sloan_email {insert into sloan_email(user_id, efl, alias, outside, last_updated) values (:user_id, :efl, :alias, :outside, sysdate)}
        
        set email_alias "$alias@sloan.mit.edu"
        db_dml update_default_mail { update parties set email = :email_alias where party_id = :user_id }
        
        # Need to release lock
    } 

    
    ad_returnredirect "new-explain?[export_vars -url {return_url alias efl outside}]"

    # Notify the user that an admin has changed the login for the user 

    set body "
Your Sloan Alias (SloanName) and your new login to 
[ad_system_name] is now $email_alias

Your password remains the same.

Your Sloan EFL is $efl@sloan.mit.edu
and all email sent to $email_alias and $efl@sloan.mit.edu 
will be forwarded to your original email address ($outside) on the next
system update (about 1 hour from now).

After the system update you will be able to publicise your Sloan
EFL ($efl@sloan.mit.edu) and your Sloan Alias $email_alias as 
your permanent email
addresses."

    ns_sendmail $outside \
        [ad_parameter -package_id [ad_acs_kernel_id] SystemOwner] \
        "Login email for [ad_system_name] changed to $email_alias" \
        $body
    

    ad_script_abort
}
