ad_proc -public phb_query_csv {query_name query {binds {}}} {

    Build a csv file from a query with headings defined by the column names

    @author Jeff Davis (davis@xarg.net)

    @param query_name the name of the provided query
    @param query the actual query
    @param binds a list of bind variables to upvar from the callers environment

    @return the resulting table html fragment
} {
    foreach bind $binds {
        upvar $bind $bind
    }

    set out {}
    set row 0
    db_foreach $query_name $query -column_set results {
        if {! $row} {
            set sep {}
            for {set i 0} {$i < [ns_set size $results]} {incr i} {
            append out "$sep\"[util_escape_quotes_for_csv [string trim [ns_set key $results $i]]]\""
                set sep ","
            }
            append out "\n"
            incr row
        }

        set sep {}
        for {set i 0} {$i < [ns_set size $results]} {incr i} {
            set val [string trim [ns_set value $results $i]]
            if {[regexp {^[0-9]*\.?[0-9]*$} $val]} {
                append out "$sep$val"
            } else {
                append out "$sep\"[util_escape_quotes_for_csv $val]\""
            }
            set sep ","
        }
        append out "\n"
    }

    return $out
}

permission::require_permission -object_id [ad_conn package_id] -privilege admin

ns_return 200 application/csv [phb_query_csv get {select data_type,group_name,short_name, seq from phb_backing_data order by data_type, group_name, seq, short_name}]
