ad_page_contract { 
    browse/search metadata
} { 
    {datatype:trim {}}
    {groupname:trim {}}
    {q {}}
}
permission::require_permission -object_id [ad_conn package_id] -privilege admin

db_multirow datatypes datatypes {select data_type, count(*) as n from phb_backing_data group by data_type order by data_type}
    
if {![empty_string_p $datatype]} { 
    db_multirow groups groups {
        select group_name, count(*) as n from phb_backing_data where group_name is not null and data_type = :datatype group by group_name order by group_name
    }

    if {![empty_string_p $groupname]} { 
        db_multirow data databygroup {select short_name, seq from phb_backing_data where group_name = :groupname and data_type = :datatype order by seq,short_name}
    } elseif {[template::multirow size groups] == 0} { 
        db_multirow data databytype {select short_name, seq from phb_backing_data where data_type = :datatype order by seq,short_name}
    } else {
        set data:rowcount 0        
    }
} else {
    set data:rowcount 0        
    set groups:rowcount 0
}

multirow extend data edit_url delete_url 
set return_url "md?[export_vars -url {datatype groupname}]"

template::multirow foreach data { 
    set edit_url "md-ae?[export_vars -url {datatype groupname {orig_name {$short_name}} {shortname {$short_name}}}]"
    set delete_url "md-delete?[export_vars -url {datatype short_name return_url}]"
}


