ad_page_contract { 
    add edit category
} { 
    {datatype:trim {}}
    {groupname:trim {}}
    {shortname:trim {}}
    {orig_name:trim {}}
    {seq:integer {}}
    {return_url ./md}
    cancel:optional
} 

permission::require_permission -object_id [ad_conn package_id] -privilege admin

if {[info exists cancel]} { 
    ad_returnredirect $return_url
    ad_script_abort
}

if {![empty_string_p $orig_name]} { 
    set help "Originally: $orig_name"
    set title "Edit: $orig_name : $datatype"
} else { 
    set help {}
    if {![empty_string_p $datatype]} { 
        set title "Add a $datatype"
    } else { 
        set title "Add a select option"
    } 
}

ad_form -name cat -form {
    {data_type:text(select)
        {options {[db_list_of_lists datatypes {select distinct data_type, data_type from phb_backing_data}]}}
        {value $datatype}
        {label {Data type}}
    }
    {group_name:text(select)
        {options {[concat {{-- {}}} [db_list_of_lists datatypes {select distinct data_type || ' : ' || group_name as key, group_name from phb_backing_data where group_name is not null order by key}]]}}
        {value $groupname}
        {label {Group}}
    }
    {short_name:text(text) 
        {html {size 60 maxlength 100}}
        {value $shortname}
        {label String}
        {help_text $help}
        required
    }
    {orig_name:text(hidden) 
        {value $orig_name}
        {label String}
    }
    {orig_type:text(hidden) 
        {value $datatype}
        {label String}
    }
    {return_url:text(hidden) 
        {value "md?[export_vars -url {datatype groupname}]"}
    }
} -validate { 
    {short_name {![string is space $short_name]} {You must provide a string for the select list}}
} -on_submit { 
    if {![string is space $orig_name]} { 
        db_dml update {update phb_backing_data set data_type = :data_type, short_name = :short_name, group_name = :group_name where short_name = :orig_name and data_type = :orig_type}
        util_memoize_flush "phb::options_no_cache $data_type"
        util_memoize_flush "phb::options_no_cache $orig_type"
        util_memoize_flush "phb::options_grouped_no_cache $data_type"
        util_memoize_flush "phb::options_grouped_no_cache $orig_type"
    } else { 
        db_dml insert {insert into phb_backing_data (data_type, short_name, group_name, seq) values (:data_type, :short_name, :group_name, 0)}
        util_memoize_flush "phb::options_no_cache $data_type"
        util_memoize_flush "phb::options_grouped_no_cache $data_type"
    }

    ad_returnredirect $return_url
}

