    <property name="title">Photobook docs</property>


    <p>
      The tables are all stored as cr_revisions, with the parent 
      object being the phb_person record and the children being 
      related via cr_child_rels to the parent record.
    </p>
    <p>
      What this means is that a query to get the set of images for a 
      user would look like: 
    </p>
    <pre>
select i.item_id, i.name as user_key, i.parent_id as folder_id,
              nvl(p.preferred_name,p.first_name) as first_name,
              p.last_name, p.user_id, p.priv,p.priv_portrait,
              rel.relation_tag,
              imi.item_id as image_id, imi.live_revision as image_revision_id,
              imr.filename,
              o.creation_date, o.creation_ip, o.creation_user,
              im.width, im.height
from cr_items i, phb_person p, cr_child_rels rel, cr_items imi, cr_revisions imr, images im, acs_objects o
        where i.live_revision = p.person_id
          and rel.parent_id = i.item_id
          and imi.item_id = rel.child_id
          and imr.revision_id = imi.live_revision
          and im.image_id = imr.revision_id
          and o.object_id = imr.revision_id;
    </pre>
    <p>
      In this case rel.relation_tag would be one of 'portrait_base',
      'portrait_small', 'portrait_thumb'.  Similiarly for the things
      stored as spans, they would have a parent_id of the users
      phb_person item_id and a relation tag of 'job_current',
      'degree', etc.
  </p>


      <h1>PHB_PERSON</h1>
      <pre>
 Name				     Null?    Type
 ----------------------------------- -------- ------------------------
 PERSON_ID			     NOT NULL NUMBER(38)
 USER_ID				      NUMBER(38)
 INSTITUTE_ID				      VARCHAR2(100)
 PRIV					      NUMBER(38)
 SALUTATION				      VARCHAR2(20)
 FIRST_NAME				      VARCHAR2(200)
 MIDDLE_NAME				      VARCHAR2(200)
 LAST_NAME				      VARCHAR2(200)
 SUFFIX 				      VARCHAR2(20)
 PREFERRED_NAME 			      VARCHAR2(200)
 PRIV_PREFERRED_NAME			      NUMBER(38)
 FORMER_NAME				      VARCHAR2(200)
 PRIV_FORMER_NAME			      NUMBER(38)
 GENDER 				      VARCHAR2(10)
 PRIV_GENDER				      NUMBER(38)
 BIRTHDATE				      DATE
 PRIV_BIRTHDATE 			      NUMBER(38)
 ETHNICITY				      VARCHAR2(200)
 PRIV_ETHNICITY 			      NUMBER(38)
 EMAIL_PRIMARY				      VARCHAR2(200)
 PRIV_EMAIL_PRIMARY			      NUMBER(38)
 EMAIL_OUTSIDE				      VARCHAR2(200)
 PRIV_EMAIL_OUTSIDE			      NUMBER(38)
 EMAIL_EFL				      VARCHAR2(200)
 PRIV_EMAIL_EFL 			      NUMBER(38)
 PROGRAM				      VARCHAR2(100)
 PRIV_PROGRAM				      NUMBER(38)
 CLASS_YEAR				      VARCHAR2(20)
 PRIV_CLASS_YEAR			      NUMBER(38)
 PREFERRED_GRADUATION			      VARCHAR2(10)
 EXPECTED_GRADUATION			      VARCHAR2(10)
 LIVING_GROUP				      VARCHAR2(100)
 PRIV_LIVING_GROUP			      NUMBER(38)
 UROP_1 				      VARCHAR2(100)
 UROP_2 				      VARCHAR2(100)
 PRIV_UROP				      NUMBER(38)
 PAST_EMPLOYERS 			      VARCHAR2(1000)
 PRIV_PAST_EMPLOYERS			      NUMBER(38)
 CONCENTRATION_1			      VARCHAR2(100)
 CONCENTRATION_2			      VARCHAR2(100)
 PRIV_CONCENTRATION			      NUMBER(38)
 ACADEMIC_INTEREST_1			      VARCHAR2(100)
 ACADEMIC_INTEREST_2			      VARCHAR2(100)
 ACADEMIC_INTEREST_3			      VARCHAR2(100)
 PRIV_ACADEMIC_INTEREST 		      NUMBER(38)
 OUTSIDE_INTEREST_1			      VARCHAR2(100)
 OUTSIDE_INTEREST_2			      VARCHAR2(100)
 OUTSIDE_INTEREST_3			      VARCHAR2(100)
 PRIV_OUTSIDE_INTEREST			      NUMBER(38)
 PRIV_ORIGIN				      NUMBER(38)
 PRIV_CITIZENSHIP			      NUMBER(38)
 MARITAL_STATUS 			      VARCHAR2(30)
 PRIV_MARITAL_STATUS			      NUMBER(38)
 PARTNER_FIRSTNAME			      VARCHAR2(200)
 PARTNER_LASTNAME			      VARCHAR2(200)
 PRIV_PARTNER				      NUMBER(38)
 CHILD_1				      VARCHAR2(200)
 CHILD_BORN_1				      NUMBER(38)
 CHILD_2				      VARCHAR2(200)
 CHILD_BORN_2				      NUMBER(38)
 CHILD_3				      VARCHAR2(200)
 CHILD_BORN_3				      NUMBER(38)
 CHILD_4				      VARCHAR2(200)
 CHILD_BORN_4				      NUMBER(38)
 CHILD_5				      VARCHAR2(200)
 CHILD_BORN_5				      NUMBER(38)
 PRIV_CHILD				      NUMBER(38)
 FAVORITE_PLACE 			      VARCHAR2(100)
 PRIV_FAVORITE_PLACE			      NUMBER(38)
 FAVORITE_BOOK				      VARCHAR2(100)
 PRIV_FAVORITE_BOOK			      NUMBER(38)
 FAVORITE_MOVIE 			      VARCHAR2(100)
 PRIV_FAVORITE_MOVIE			      NUMBER(38)
 ONE_WORD_DESCRIPTION			      VARCHAR2(100)
 PRIV_ONE_WORD_DESCRIPTION		      NUMBER(38)
 LANGUAGE_1				      VARCHAR2(200)
 LANGUAGE_2				      VARCHAR2(200)
 LANGUAGE_3				      VARCHAR2(200)
 PRIV_LANGUAGE				      NUMBER(38)
 STATUS 				      VARCHAR2(100)
 STATUS_NOTE				      VARCHAR2(4000)
 PRIV_PORTRAIT				      NUMBER(38)
 PRIV_PERSONAL				      NUMBER(38)
 PRIV_ADDRESS				      NUMBER(38)
 PRIV_EMPLOYMENT			      NUMBER(38)
 PRIV_EDUCATION 			      NUMBER(38)
 ORIGIN 				      CHAR(2)
 CITIZENSHIP				      CHAR(2)
      </pre>

      <h2>PHB_ADDRESS</h2>
      <pre>
 Name				     Null?    Type
 ----------------------------------- -------- ------------------------
 ADDRESS_ID			     NOT NULL NUMBER(38)
 PRIV					      NUMBER(38)
 ADDRESS_TYPE				      VARCHAR2(100)
 ADDRESS_OTHER				      VARCHAR2(100)
 ADDRESS_1				      VARCHAR2(100)
 ADDRESS_2				      VARCHAR2(100)
 ADDRESS_3				      VARCHAR2(100)
 PRIV_ADDRESS				      NUMBER(38)
 CITY					      VARCHAR2(200)
 STATE					      VARCHAR2(100)
 POSTCODE				      VARCHAR2(25)
 COUNTRY				      CHAR(2)
      </pre>

      <h2>PHB_PHONE</h2>
      <pre>
 Name				     Null?    Type
 ----------------------------------- -------- ------------------------
 PHONE_ID			     NOT NULL NUMBER(38)
 PRIV					      NUMBER(38)
 PHONE_TYPE				      VARCHAR2(100)
 OTHER_DESCRIPTION			      VARCHAR2(100)
 COUNTRY_CODE				      VARCHAR2(5)
 AREA_CODE				      VARCHAR2(5)
 PHONE_NUMBER				      VARCHAR2(12)
 EXTENSION				      VARCHAR2(12)
      </pre>

      <h2>PHB_SPAN</h2>
      <pre>
 Name				     Null?    Type
 ----------------------------------- -------- ------------------------
 SPAN_ID			     NOT NULL NUMBER(38)
 PRIV					      NUMBER(38)
 SPAN_TYPE				      VARCHAR2(20)
 INSTITUTION				      VARCHAR2(200)
 LOCATION				      VARCHAR2(200)
 DEPARTMENT				      VARCHAR2(200)
 RELATION				      VARCHAR2(100)
 TEXT_DATE				      VARCHAR2(100)
 STARTED				      DATE
 ENDED					      DATE
      </pre>

