ad_page_contract { 
    Edit user data.

    @author Jeff Davis (davis@xarg.net)
    @creation-date 15 Febuary 2003
    @cvs-id $Id: ae.tcl,v 1.1 2003/11/03 20:10:56 janines Exp $
} { 
    {user_id:integer,optional {}}
    {form_type:optional p}
    {ad:integer 1}
    {return_url {}}
} 

set my_user_id [phb::dispatch -page edit -user_id $user_id]

if {[empty_string_p $user_id] || !$user_id} { 
    set user_id $my_user_id
}

set admin_p [expr {$ad && [permission::permission_p -party_id $my_user_id -object_id [ad_conn package_id] -privilege admin]}]

# Check admin if editing another user.
if {![string equal $user_id $my_user_id] || $form_type == "z"} { 
    permission::require_permission -party_id $my_user_id -object_id [ad_conn package_id] -privilege admin
    set formless_url "[phb::package_url]ae?ad=$ad&user_id=$user_id&form_type="
} else { 
    set formless_url "[phb::package_url]ae?form_type="
}

#
# Build a forms multirow for the available editing forms.
# 
# Check the form is valid as well
set found_form_p 0

multirow create forms key name tip selected 

foreach {key name tip} { 
    p personal {Edit personal data}
    m employment {Edit employment history}
    a address {Edit contact data}
    e education {Edit educational history}
    z admin {Edit Administrative data}
    {} full {Edit all data}
} { 
    if {($key != "z" && $key != "") || $admin_p} { 
        set selected 0
        if {[string equal $form_type $key]} { 
            set found_form_p 1 
            set selected 1
            set form_name $name
        } 
        multirow append forms $key $name $tip $selected
    } 
} 

if {!$found_form_p} { 
    ad_return_complaint 1 "The form type sent to this page is not valid."
    ad_script_abort
} 

if {[lsearch {main education personal employment address} $form_name] == -1 } { 
    set display main
} else { 
    set display $form_name
} 

#
# Now do the actual form create etc.
#

form create phpb -html { enctype "multipart/form-data" }

phb::form::create \
    -form_name phpb \
    -user_id $user_id \
    -admin=$admin_p \
    -form_type $form_type

template::element create phpb return_url \
    -datatype text \
    -widget hidden \
    -value $return_url 

if {[template::element::exists phpb outside]
    && ![form is_request phpb]} { 
    template::form get_values phpb outside efl alias

    set alias [string trim $alias]
    set efl [string trim $efl]
    set outside [string trim $outside]
    if {$admin_p} { 
        if {![empty_string_p $alias]} { 
            if {![regexp {^[A-Za-z0-9_]{3,20}$} $alias]} { 
                template::element set_error phpb alias "Alias must be 3-20 characters and may only contain letters, numbers, and \"_\""
            } elseif {!$admin_p && ![phb::email_available [string trim $alias] $user_id]} { 
                template::element set_error phpb alias "\"$alias\" is already in use.  Please choose another alias."
            } 
        } 
        
        if {![empty_string_p $efl]} { 
            if {![regexp {^[A-Za-z0-9._]{3,}$} $efl]} { 
                template::element set_error phpb efl "EFL may only contain letters, numbers, \"_\" and \".\""
            } elseif {!$admin_p && ![phb::email_available [string trim $efl] $user_id]} {
                template::element set_error phpb efl "\"$efl\" is already in use.  Please choose another EFL."
            } 
        } 
    } 
}

    

if {[form is_valid phpb]} { 
    # We got a completely valid form w00t.

    # check name not a dup, which also serves and the doubleclick prot.
    phb::preinsert phpb

    db_transaction { 
        set items [content::new_item phpb]
        # set the live revision to the latest revision
        foreach id $items { 
            cr::item::set_latest_revision_live -item_id $id
        }

        # Update sloan_email and parties tables as appropriate

        set changed_login_p 0
        # we've had some trouble with students who have a pre-existing
        # EFL, so can't enter their own, but can't have it set by an
        # admin either because this row doesn't exist yet
        if { [db_string email_row_ck "select count(*) from sloan_email where user_id = :user_id"] == 0 } {
          db_dml insert_sloan { insert into sloan_email (user_id, outside, efl, alias, last_updated) values (:user_id, :outside, :efl, :alias, sysdate) }
        } else {
          db_dml update_sloan { update sloan_email set outside = :outside, efl = :efl, alias = :alias, last_updated = sysdate where user_id = :user_id}
        }
        if {![empty_string_p $alias]} { 
            set email_alias "$alias@sloan.mit.edu"
            
            set changed_login_p [db_string changed_login "select count(*) from dual where not exists (select * from parties where email = :email_alias and party_id = :user_id)"]
            if { $changed_login_p } {
                db_dml update_default_mail { update parties set email = :email_alias where party_id = :user_id }
            }
        }
    } 
    
    if {[exists_and_not_null return_url]} { 
        ad_returnredirect $return_url
    } else { 
        ad_returnredirect "display/$user_id/$display"
    } 

    # Notify the user that an admin has changed the login for the user 
    if {$changed_login_p} { 
        set body "Your [ad_system_name] login email has been changed to $email_alias.\n"
        
        if {![string equal $outside $email_alias]} { 
            append body "Email from [ad_system_name] should be forwarded to $outside.\n"
        } 
        ns_sendmail $outside \
            [ad_parameter -package_id [ad_acs_kernel_id] SystemOwner] \
            "Login email for [ad_system_name] changed to $email_alias" \
            $body
    } 
    
    ad_script_abort

} elseif {![form is_request phpb]} { 
    set debug "Invalid!"
    upvar #[template::adp_level] phpb:error formerror
    append debug [array get formerror]
}
