ReturnHeaders text/plain 

foreach widget { 
    {institute_id text optional { 
        {size literal 10}
        {maxlength literal 10}
        {validate literal {inst_id_num {string is integer $value} {institute id must be a number}}}}
    }
    {salutation select optional {
        {options eval {phb::options -key salutation}} }
    }
    {first_name text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {middle_name text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {last_name text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {suffix select optional { 
        {options eval {phb::options -key suffix}} }
    }
    {preferred_name text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {former_name text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {gender select optional { 
        {options eval {phb::options -key gender}} }
    }
    {birthdate date optional {
        {year_interval literal {1930 1999 1}} }
    }
    {ethnicity select optional { 
        {options eval {phb::options -key ethnicity}} }
    }
    {marital_status select optional { 
        {options eval {phb::options -key maritalstatus}} }
    }
    {partner_firstname text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {partner_lastname text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {child_1 text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {child_born_1 select optional { 
        {size literal 1}
        {options eval {phb::year_options -start 0 -end -30}}} 
    }
    {child_2 text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {child_born_2 select optional { 
        {size literal 1}
        {options eval {phb::year_options -start 0 -end -30}}} 
    }
    {child_3 text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {child_born_3 select optional { 
        {size literal 1}
        {options eval {phb::year_options -start 0 -end -30}}} 
    }
    {child_4 text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {child_born_4 select optional { 
        {size literal 1}
        {options eval {phb::year_options -start 0 -end -30}}} 
    }
    {child_5 text optional { 
        {size literal 60}
        {maxlength literal 200}}
    }
    {child_born_5 select optional { 
        {size literal 1}
        {options eval {phb::year_options -start 0 -end -30}}} 
    }
    {language_1 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {language_2 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {language_3 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {academic_interest_1 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {academic_interest_2 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {academic_interest_3 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {outside_interest_1 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {outside_interest_2 text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {outside_interest_3 text optional { 
        {size literal 60}
        {maxlength literal 100} }
    }
    {origin select optional { 
        {options eval {phb::country_options -prefix {{-- {}} {{United States} US} {Canada CA} {-- {}}}}} }
    }
    {citizenship select optional { 
        {options eval {phb::country_options -prefix {{-- {}} {{United States} US} {Canada CA} {-- {}}}}} }
    }
    {favorite_place text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {favorite_movie text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {favorite_book text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {one_word_description text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {program select optional { 
        {options eval {phb::options -key program}}}
    }
    {class_year select optional { 
        {options eval {phb::year_options -start -1 -end 15}}} 
    }
    {expected_graduation select optional {
        {options eval {phb::year_options -start -1 -end 15}}} 
    }
    {preferred_graduation select optional { 
        {options eval {phb::year_options -start -1 -end 15}} }
    }
    {living_group select optional { 
        {options eval {phb::options -key livinggroup}}}
    }
    {urop_1 text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {urop_2 text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {concentration_1 select optional { 
        {options eval {concat [phb::options -key concentration_ug ] [phb::options -key concentration_phd]}}}
    }
    {concentration_2 select  optional { 
        {options eval {concat [phb::options -key concentration_ug ] [phb::options -key concentration_phd]}}}
    }
    {email_primary text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {email_outside text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {email_efl text  optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {status select optional { 
        {options literal {{Active Active} {Inactive Inactive}}}}
    }
    {past_employers textarea  optional { 
        {rows literal 4}
        {cols literal 60}
        {wrap literal soft}}
    }
    {status_note textarea  optional { 
        {rows literal 4}
        {cols literal 60}
        {wrap literal soft}}
    }
} {
    foreach {key widget required params} $widget { break }
    ns_write "Register: $key:$widget\n"

    cms_widget_register -content_type phb_person \
        -attribute $key \
        -widget $widget \
        -required=[string equal $required required] \
        -params $params
}




