ReturnHeaders text/plain 

#set type [db_string max "select lower(max(table_name)) from user_tables where table_name like 'PHB_SPAN%'"]

set type phb_span

foreach widget { 
    {span_type text optional { 
        {size literal 20} 
        {maxlength literal 20} }
    }
    {institution text optional { 
        {size literal 60} 
        {maxlength literal 200} }
    }
    {department text optional {
        {size literal 60}
        {maxlength literal 100}}
    }
    {location text optional {
        {size literal 60}
        {maxlength literal 100}}
    }
    {relation text optional { 
        {size literal 60}
        {maxlength literal 100}}
    }
    {started date optional { 
        {year_interval literal {1970 2003 1}}
        {format literal {Month/YYYY}} }
    }
    {ended date optional { 
        {year_interval literal {1970 2003 1}}
        {format literal {Month/YYYY}} }
    }
} {
    foreach {key widget required params} $widget { break }
    ns_write "Register: $type:$key:$widget\n"

    cms_widget_register -content_type $type \
        -attribute $key \
        -widget $widget \
        -required=[string equal $required required] \
        -params $params
}




