#
#  Copyright (C) 2001, 2002 MIT
#
#  This file is part of dotLRN.
#
#  dotLRN is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 2 of the License, or (at your option) any later
#  version.
#
#  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
#  details.
#

ad_page_contract {
    Process the upload

    @author Don Baccus
    @creation-date 2003-09
    @version $Id: users-bulk-upload-2.tcl,v 1.1 2003/11/03 20:10:56 janines Exp $
}

# get location of the file
set file_location [ns_queryget users_csv_file.tmpfile]

set admin_user_id [ad_verify_and_get_user_id]
set admin_email [db_string select_admin_email {
    select email
    from parties
    where party_id = :admin_user_id
}]

doc_body_append "Bulk Uploading Photobook stuff....<p>"

# cr item folder for this instance of photobook.
set parent_id [phb::root_folder]

set rejects_fp [open [acs_package_root_dir photobook]/www/admin/rejects.csv w]
set processed_fp [open [acs_package_root_dir photobook]/www/admin/processed.csv w]
set errors_fp [open [acs_package_root_dir photobook]/www/admin/errors.txt w]
set missing_alias_fp [open [acs_package_root_dir photobook]/www/admin/missing-alias.txt w]
set email_fp [open [acs_package_root_dir photobook]/www/admin/email.txt w]
puts $rejects_fp "SPMITID,SPLASTNAME,SPFIRSTNAME,SPSLOANEMAIL,SPFORWARDINGEMAIL,SPALIAS,STDEGREEPROG,STREALGRADUATE"
puts $processed_fp "SPMITID,SPLASTNAME,SPFIRSTNAME,SPSLOANEMAIL,SPFORWARDINGEMAIL,SPALIAS,STDEGREEPROG,STREALGRADUATE"
puts $missing_alias_fp "SPMITID,SPLASTNAME,SPFIRSTNAME,SPSLOANEMAIL,SPFORWARDINGEMAIL,SPALIAS,STDEGREEPROG,STREALGRADUATE"
puts $email_fp "SPMITID,SPLASTNAME,SPFIRSTNAME,SPSLOANEMAIL,SPFORWARDINGEMAIL,SPALIAS,STDEGREEPROG,STREALGRADUATE"

set rejects 0
set processed 0
set missing_alias 0
set alias_error_p 0
set will_email 0
set will_email_p 0

# Form creation hack!

ad_form -name new-user -export { 
    parent_id 
    {item_id {}}
    {revision_id {}}
    {name {}}
    {first_name {}}
    {middle_name {}}
    {last_name {}}
    {institute_id {}}
    {program {}}
    {class_year {}}
    {expected_graduation {}}
    {email_outside {}}
    {email_efl {}}
    {content_type phb_person} 
    {content_method no_content}
} -form {
    {dummy:text {}}
}

# Hack to help debug data - assumes data file covers one class year and program
set group_class_year ""
set group_program ""

oacs_util::csv_foreach -file $file_location -array_name row {

   incr processed
   set send_notification_p 0

   db_transaction {
                    
        # This just makes the cut and paste from new.tcl a little easier ...
        set institute_id $row(spmitid)
        set last_name $row(splastname)
        set middle_name $row(spmiddle)
        set first_name $row(spfirstname)
        set alias $row(spalias)
        set email_outside $row(spforwardingemail)
        set outside $row(spforwardingemail)
        set efl $row(spsloanemail)
        set email_efl $row(spsloanemail)
        set program $row(stdegreeprog)
        set expected_graduation $row(strealgraduate)
        set class_year $row(strealgraduate)

        if { [string equal $program "Master's"] } {
            set program "MBA"
        } elseif { [string equal $program "Leaders for Manufacturing"] } {
            set program "LFM (Leaders for Manufacturing)"
        } elseif { [string equal $program "SDM"] } {
            set program "SDM (Systems Design Management)"
        } elseif { [string equal $program "Management of Technology"] } {
            set program "MOT (Management of Technology)"
        }

        if { [string length $group_class_year] == 0 } {
            set group_class_year $class_year
        }

        if { [string length $group_program] == 0 } {
            set group_program $program
        }

        doc_body_append "Processing $row(spfirstname) $row(splastname)<br>"

        # if they aren't found, this will error out and cause them to be
        # rejected
        db_1row basic_info {select p.user_id, pa.email as orig_email
                            from phb_personx p, cr_items i, parties pa
                            where  p.item_id = i.item_id
                            and p.revision_id = i.live_revision
                            and p.user_id = pa.party_id
                            and p.institute_id = :institute_id}

        # since they were found, we know they have a photobook record already
        db_dml update_phb_person {
            update phb_person
            set email_outside = :email_outside,
                email_efl = :email_efl
            where user_id = :user_id
        }

        # create the email record if one does not exist, otherwise update
        if { [db_0or1row sloan_email { 
            select 1
            from sloan_email
            where user_id = :user_id }] } {

            db_dml update_sloan_email {
                update sloan_email set efl = :efl, alias = :alias, outside = :outside, last_updated = sysdate where user_id = :user_id
            }
        } else {
            db_dml create_sloan_email {
                insert into sloan_email(user_id, efl, alias, outside, last_updated)
                values (:user_id, :efl, :alias, :outside, sysdate)
            }
        }

        if { [string length $alias] == 0 } {
            set alias_error_p 1
        } else {
            set email_alias "$alias@sloan.mit.edu"

            # update login address if it has changed, and notify user
            if { [string compare $orig_email $email_alias] } {
                set will_email_p 1
                db_dml update_default_mail { update parties set email = :email_alias where party_id = :user_id }
    
                set body "
    Hello $first_name,

    Your Sloan Alias (SloanName) and your new login to 
    [ad_system_name] is now $email_alias

    Your password remains the same.
    "

              if { ![string equal "" $efl] } {
                  append body "
    Your Sloan EFL is ${efl}@sloan.mit.edu
    and all email sent to $email_alias and ${efl}@sloan.mit.edu
    will be forwarded to your original email address ($outside) on the next
    system update (about 1 hour from now).
    "
              }

              # Send note to new user
              if [catch {ns_sendmail "$outside" "$admin_email" "Login email for [ad_system_name] changed to $email_alias" "$body"} errmsg] {
                  doc_body_append "emailing \"$outside\" failed! (but database changes are OK)<br>"
              }
          }
        }

        if { $alias_error_p } {
            incr missing_alias
            puts $missing_alias_fp "$row(spmitid),$row(splastname),$row(spfirstname),$row(spsloanemail),$row(spforwardingemail),$row(spalias),$row(stdegreeprog),$row(strealgraduate)"
            set alias_error_p 0
        }

        if { $will_email_p } {
            incr will_email
            puts $email_fp "$row(spmitid),$row(splastname),$row(spfirstname),$row(spsloanemail),$row(spforwardingemail),$row(spalias),$row(stdegreeprog),$row(strealgraduate)"
            set will_email_p 0
        }

        puts $processed_fp "$row(spmitid),$row(splastname),$row(spfirstname),$row(spsloanemail),$row(spforwardingemail),$row(spalias),$row(stdegreeprog),$row(strealgraduate)"
    } on_error {
        incr rejects
        doc_body_append "Error! errmsg: $errmsg<br>\n"
        puts $errors_fp "Error: $errmsg"
        puts $errors_fp "$row(spmitid),$row(splastname),$row(spfirstname),$row(spsloanemail),$row(spforwardingemail),$row(spalias),$row(stdegreeprog),$row(strealgraduate)"
        puts $errors_fp ""
        puts $rejects_fp "$row(spmitid),$row(splastname),$row(spfirstname),$row(spsloanemail),$row(spforwardingemail),$row(spalias),$row(stdegreeprog),$row(strealgraduate)"
        db_abort_transaction
    }
}

close $rejects_fp

set unprocessed_fp [open [acs_package_root_dir photobook]/www/admin/unprocessed.txt w]
set unprocessed_p 0
foreach student [db_list foo "
                    select u.first_names || u.last_name as student
                    from cc_users u, phb_person p
                    where p.user_id = u.user_id
                      and p.class_year = :group_class_year
                      and p.program = :group_program
                      and not exists (select 1
                                      from sloan_email
                                      where user_id = u.user_id)"] {
    puts $unprocessed_fp $student
    set unprocessed_p 1
}
close $unprocessed_fp
                    
doc_body_append "<p>For good or bad ... we're done! We processed $processed records<p>"

if { $unprocessed_p } {
doc_body_append "
<a href=\"users-bulk-upload-view-rejects.tcl?file=unprocessed.txt\">View students in SSV2 but not in the SED file for program $program class year $class_year</a><p>"
}

doc_body_append "
<a href=\"users-bulk-upload-view-rejects.tcl?file=processed.csv\">View processed records file</a><p>
<a href=\"users-bulk-upload-view-rejects.tcl?file=errors.txt\">View errors file</a><p>"

if { $rejects > 0 } {
    doc_body_append "<p>There were $rejects data records rejected.<br>
The rejects file is located at [acs_package_root_dir photobook]/www/admin/rejects.csv<p>
<a href=\"users-bulk-upload-view-rejects.tcl?file=rejects.csv\">View rejects file</a><p>"
}

if { $missing_alias > 0 } {
    doc_body_append "<p>There were $missing_alias data records which were missing aliases, so their login emails could not be updated.<br>
The missing aliases file is located at [acs_package_root_dir photobook]/www/admin/missing-alias.txt<p>
<a href=\"users-bulk-upload-view-rejects.tcl?file=missing-alias.txt\">View missing alias file</a><p>"
}

if { $will_email > 0 } {
    doc_body_append "<p>There were $will_email data records who will receive emails that their login has changed.<br>
The e-mail file is located at [acs_package_root_dir photobook]/www/admin/email.txt<p>
<a href=\"users-bulk-upload-view-rejects.tcl?file=email.txt\">View e-mail file</a><p>"
}
