# Create the folders and content type relations 

# Create the content_folder into which we will put phb_persons.

set root_folder_id [parameter::get -parameter RootFolder -default 0]

if { !$root_folder_id } { 
    # We didn't find the root folder id so 
    # try and create it.

    set root_folder_id [cr::folder::new \
                            -name photobook \
                            -label photobook \
                            -description "Photobook personal data" ]
    
}
# save the root folder id as a package parameter.
parameter::set_value -parameter RootFolder -value $root_folder_id
    
# register phb_person as an allowed content_type on that folder.
cr::folder::register_content_type -folder $root_folder_id -content_type phb_person -include_subtypes

# add address rel hometown, address as children of phb_person
cr::content_type::register_relation -content_type phb_person -target_type phb_address -relation hometown -min 0 -max 1
cr::content_type::register_relation -content_type phb_person -target_type phb_address -relation address -min 0 -max 1

# add phone home mobile 0 1
cr::content_type::register_relation -content_type phb_person -target_type phb_phone -relation home -min 0 -max 1
cr::content_type::register_relation -content_type phb_person -target_type phb_phone -relation mobile -min 0 -max 1


# add phb_span rel degree 0 .. current_job 0 1 past_job 0 1 internship.
cr::content_type::register_relation -content_type phb_person -target_type phb_span -relation degree -min 0 
cr::content_type::register_relation -content_type phb_person -target_type phb_span -relation job_current -min 0 -max 1
cr::content_type::register_relation -content_type phb_person -target_type phb_span -relation job_past -min 0
cr::content_type::register_relation -content_type phb_person -target_type phb_span -relation internship -min 0

# add image rel base, web, thumb...
cr::content_type::register_relation -content_type phb_person -target_type image -relation portrait_base -min 0 -max 1
cr::content_type::register_relation -content_type phb_person -target_type image -relation portrait_web -min 0 -max 1
cr::content_type::register_relation -content_type phb_person -target_type image -relation portrait_small -min 0 -max 1
cr::content_type::register_relation -content_type phb_person -target_type image -relation portrait_thumb -min 0 -max 1


# Add the view for handling images 
db_dml photo_view {create or replace view phb_portraits as 
       select i.item_id, i.name as user_key, i.parent_id as folder_id, 
              nvl(p.preferred_name,p.first_name) as first_name, 
              p.last_name, p.user_id, p.priv,p.priv_portrait,
              rel.relation_tag, 
              imi.item_id as image_id, imi.live_revision as image_revision_id,
              imr.mime_type, imr.filename, 
              o.creation_date, o.creation_ip, o.creation_user,
              im.width, im.height
from cr_items i, phb_person p, cr_child_rels rel, cr_items imi, cr_revisions imr, images im, acs_objects o
        where i.live_revision = p.person_id 
          and rel.parent_id = i.item_id
          and imi.item_id = rel.child_id
          and imr.revision_id = imi.live_revision
          and im.image_id = imr.revision_id
    and o.object_id = imr.revision_id}

ReturnHeaders text/plain
ns_write "Relations created, phb_portraits view refreshed.\n"
