#
# This needs to have an api put on top of it.  Also, 
# adding fields requires changes in some of the library routines 
# which is an issue.
#

# Create the type and attribute data 
ReturnHeaders text/plain

set type phb_person
set table_name $type

set order 90
foreach column { 
    {priv_personal
        {Suppress personal data} {Suppress personal data}
        integer integer 0 }
    {priv_address
        {Suppress address} {Suppress address}
        integer integer 0 }
    {priv_employment
        {Suppress employment} {Suppress employment}
        integer integer 0 }
    {priv_education
        {Suppress education} {Suppress education}
        integer integer 0 }
} { 
    incr order

    foreach {attribute pretty_name pretty_plural datatype column_spec default_value} $column { break }

    set column_spec [subst $column_spec]

    catch { cr::content_type::create_attribute \
                -content_type $type \
                -attribute_name $attribute \
                -datatype $datatype \
                -pretty_name $pretty_name \
                -pretty_plural $pretty_plural \
                -sort_order $order \
                -default_value $default_value \
                -column_spec $column_spec } err
    ns_write "$err\n"
}


foreach widget {} {
    foreach {key widget required params} $widget { break }
    ns_write "Register: $key:$widget\n"

    cms_widget_register -content_type $type \
        -attribute $key \
        -widget $widget \
        -required=[string equal $required required] \
        -params $params
}




