# Create the type and attribute data 
ReturnHeaders text/plain

#set max 0
#regsub {PHB_PERSON} [db_string max "select max(table_name) from user_tables where table_name like 'PHB_PERSON1%'"] {} max
#set n [expr $max + 1]

set type phb_person
set type_pretty "PHB Person"
set type_pretty_plural "PHB Persons"
set table_name phb_person

ns_write "creating type $type\n"

cr::content_type::create_type \
        -content_type $type \
        -supertype content_revision \
        -pretty_name $type_pretty \
        -pretty_plural $type_pretty_plural \
        -table_name $table_name \
        -id_column person_id \
        -name_method "" 

set order 0
foreach column { 
    {user_id
        {User ID} {User IDs} 
        integer {integer
            constraint ${type}_user_id_ref references users(user_id)
        } {} }
    {institute_id 
        {Institute ID} {Institute IDs} 
        string varchar(100) {} }
    {priv 
        {Suppress All} {Suppress flags}
        integer integer 10 }
    {salutation 
        {Salutation} {Salutations}
        string varchar(20) {} }
    {first_name
        {First name} {First names}
        string varchar(200) {} }
    {middle_name 
        {Middle name} {Middle names}
        string varchar(200) {} }
    {last_name 
        {Last name} {Last names}
        string varchar(200) {} }
    {suffix  
        {Suffix} {Suffix}
        string varchar(20) {} }
    {preferred_name 
        {Preferred name} {Preferred names}
        string varchar(200) {} }
    {priv_preferred_name 
        {Suppress preferred Name} {Suppress preferred names}
        integer integer 0 }
    {former_name 
        {Former name} {Former names}
        string varchar(200) {} }
    {priv_former_name 
        {Suppress former Name} {Suppress former names}
        integer integer 0 }
    {gender
        {Gender} {Gender}
        string varchar(10) {} }
    {priv_gender
        {Suppress Gender} {Suppress Gender}
        integer integer 0 }
    {birthdate 
        {Birthdate} {Birthdates}
        date date {} }
    {priv_birthdate
        {Suppress birthdate} {Suppress birthdates}
        integer integer 0 }
    {ethnicity
        {Ethnicity} {Ethnicity} 
        string varchar(200) {} }
    {priv_ethnicity
        {Suppress ethnicity} {Suppress ethnicity}
        integer integer 0 }
    {email_primary 
        {Sloan email alias} {Sloan email alias}
        email varchar(200) {} }
    {priv_email_primary
        {Suppress Sloan email} {Suppress Sloan email}      
        integer integer  0 } 
    {email_outside 
        {Outside email} {Outside email}
        email varchar(200) {} }
    {priv_email_outside
        {Suppress outside email} {Suppress outside email}      
        integer integer  0 } 
    {email_efl 
        {EFL email} {EFL email}
        email varchar(200) {} }
    {priv_email_efl
        {Suppress efl email} {Suppress efl email}      
        integer integer  0 }
    {program 
        {Program} {Programs}
        string {varchar(100)} {} }
    {priv_program  
        {Suppress program} {Suppress programs}           
        integer integer  0 }
    {class_year 
        {Class year} {Class years} 
        string varchar(20) {} }
    {priv_class_year  
        {Suppress class year} {Suppress class years}         
        integer integer  0 }
    {preferred_graduation 
        {Preferred date of graduation} {Preferred dates of graduation} 
        string varchar(10) {} }
    {expected_graduation 
        {Expected date of graduation} {Expected dates of graduation} 
        string varchar(10) {} }
    {living_group 
        {Living group} {Living groups}
        string {varchar(100)} {} }
    {priv_living_group  
        {Suppress living group} {Suppress living groups}      
        integer integer  0 }
    {urop_1
        {UROP 1} {UROP}       
        string {varchar(100)} {} }
    {urop_2
        {UROP 2} {UROP}       
        string {varchar(100)} {} }
    {priv_urop
        {Suppress urop} {Suppress urop}                     
        integer integer  0 }
    {past_employers
        {Past employers} {Past employers} 
        string varchar(1000) {} }
    {priv_past_employers
        {Suppress past employers} {Suppress past employers} 
        integer integer 0 }
    {concentration_1
        {Concentration} {Concentrations} 
        string {varchar(100)} {} }
    {concentration_2
        {Second concentration} {Concentrations} 
        string {varchar(100)} {} }
    {priv_concentration  
        {Suppress concentration} {Suppress concentrations}      
        integer integer  0 } 
    {academic_interest_1 
        {Academic interest 1} {Academic interests}
        string varchar(100) {} }
    {academic_interest_2 
        {Academic interest 2} {Academic interests}
        string varchar(100) {} }
    {academic_interest_3 
        {Academic interest 3} {Academic interests}
        string varchar(100) {} }
    {priv_academic_interest
        {Suppress academic interests} {Suppress academic interests} 
        integer integer  0 }
    {outside_interest_1 
        {Outside interest 1} {Outside interests} 
        string varchar(100) {} }
    {outside_interest_2 
        {Outside interest 2} {Outside interests} 
        string varchar(100) {} }
    {outside_interest_3 
        {Outside interest 3} {Outside interests} 
        string varchar(100) {} }
    {priv_outside_interest  
        {Suppress outside interests} {Suppress outside interests}  
        integer integer  0 }
    {origin 
        {Country of origin/birth} {Countries of origin} 
        string {char(2) constraint ${type}_origin_fk references countries(iso)} {} }
    {priv_origin  
        {Suppress country of Origin} {Suppress countries of Origin}             
        integer integer  0 }
    {citizenship 
        {Country of citizenship} {Countries of citizenship}
        string {char(2) constraint ${type}_citizenship_fk references countries(iso)} {} }
    {priv_citizenship  
        {Suppress country of Citizenship} {Suppress countries of Citizenship}       
        integer integer  0 }
    {marital_status 
        {Marital status} {Marital status}
        string varchar(30) {} }
    {priv_marital_status
        {Suppress marital status} {Suppress marital status}
        integer integer  0 }
    {partner_firstname 
        {Spouse/Partner first name} {Spouses/Partners first names}
        string varchar(200) {} }
    {partner_lastname
        {Spouse/Partner last name} {Spouses/Partners last name}
        string varchar(200) {} }
    {priv_partner  
        {Suppress spouse/Partner} {Suppress spouses/Partners}           
        integer integer  0 }
    {child_1
        {Child 1} {Children}
        string varchar(200) {} }
    {child_born_1
        {Child 1 born} {Children born}
        integer integer {} }
    {child_2
        {Child 2} {Children}
        string varchar(200) {} }
    {child_born_2
        {Child 2 born} {Children born}
        integer integer {} }
    {child_3
        {Child 3} {Children}
        string varchar(200) {} }
    {child_born_3
        {Child 3 born} {Children born}
        integer integer {} }
    {child_4
        {Child 4} {Children}
        string varchar(200) {} }
    {child_born_4
        {Child 4 born} {Children born}
        integer integer {} }
    {child_5
        {Child 5} {Children}
        string varchar(200) {} }
    {child_born_5
        {Child 5 born} {Children born}
        integer integer {} }
    {priv_child
        {Suppress children} {Suppress Children}
        integer integer  0 }
    {favorite_place 
        {Favorite place in the world} {Favorite places in the world} 
        string {varchar(100)} {} }
    {priv_favorite_place  
        {Suppress favorite place} {Suppress favorite places}     
        integer integer  0 }
    {favorite_book 
        {Favorite book} {Favorite book}
        string {varchar(100)} {} }
    {priv_favorite_book  
        {Suppress favorite book} {Suppress favorite book}     
        integer integer 0 }
    {favorite_movie 
        {Favorite movie} {Favorite movie}
        string {varchar(100)} {} }
    {priv_favorite_movie 
        {Suppress favorite movie} {Suppress favorite movie}    
        integer integer 0 }
    {one_word_description 
        {One word to describe me} {One word descriptions}
        string {varchar(100)} {} }
    {priv_one_word_description
        {Suppress one word description} {Suppress one word descriptions}          
        integer integer  0 }
    {language_1
        {Language 1} {Languages}
        string varchar(200) {} }
    {language_2
        {Language 2} {Languages}
        string varchar(200) {} }
    {language_3
        {Language 3} {Languages}
        string varchar(200) {} }
    {priv_language
        {Suppress languages} {Suppress Languages}
        integer integer 0 }
    {status
        {Status} {Status} 
        string varchar(100) {} }
    {status_note
        {Status note} {Status notes}
        string varchar(4000) {} }
    {priv_portrait
        {Suppress portrait} {Suppress portrait}
        integer integer 0 }
    {priv_personal
        {Suppress personal data} {Suppress personal data}
        integer integer 0 }
    {priv_address
        {Suppress address} {Suppress address}
        integer integer 0 }
    {priv_employment
        {Suppress employment} {Suppress employment}
        integer integer 0 }
    {priv_education
        {Suppress education} {Suppress education}
        integer integer 0 }
} { 
    incr order

    foreach {attribute pretty_name pretty_plural datatype column_spec default_value} $column { break }

    set column_spec [subst $column_spec]

    catch { cr::content_type::create_attribute \
                -content_type $type \
                -attribute_name $attribute \
                -datatype $datatype \
                -pretty_name $pretty_name \
                -pretty_plural $pretty_plural \
                -sort_order $order \
                -default_value $default_value \
                -column_spec $column_spec } err
    ns_write "$err\n"
}



