# Create the type and attribute data 
ReturnHeaders text/plain

set type phb_phone
set type_pretty "PHB Phone"
set type_pretty_plural "PHB Phones"
set table_name phb_phone
ns_write "creating type $type\n"

cr::content_type::create_type \
    -content_type $type \
    -supertype content_revision \
    -pretty_name $type_pretty \
    -pretty_plural $type_pretty_plural \
    -table_name $table_name \
    -id_column phone_id \
    -name_method "" 

set order 0

foreach column { 
    {priv 
        {Suppress All} {Suppress flags}
        integer integer 0}
    {phone_type 
        {Phone type} {Phone type}
        string varchar(100) {}}
    {other_description
        {Phone other} {Phone others}
        string varchar(100) {}}        
    {area_code
        {Area code} {Area Code}
        string varchar(5) {}}
    {phone_number
        {Phone number} {Phone number}
        string varchar(12) {}}
    {country_code 
        {Country code} {Country codes}
        string varchar(5) {+1}}
    {extension
        {Extension} {Extension}
        string varchar(12) {}}
} { 
    incr order

    foreach {attribute pretty_name pretty_plural datatype column_spec default_value} $column { break }

    set column_spec [subst $column_spec]

    catch { cr::content_type::create_attribute \
                -content_type $type \
                -attribute_name $attribute \
                -datatype $datatype \
                -pretty_name $pretty_name \
                -pretty_plural $pretty_plural \
                -sort_order $order \
                -default_value $default_value \
                -column_spec $column_spec } err
    ns_write "$err\n"
}
