# Create the type and attribute data 
ReturnHeaders text/plain

set type phb_span
set type_pretty "PHB Span"
set type_pretty_plural "PHB Spans"
set table_name phb_span

ns_write "creating type $type\n"

cr::content_type::create_type \
        -content_type $type \
        -supertype content_revision \
        -pretty_name $type_pretty \
        -pretty_plural $type_pretty_plural \
        -table_name $table_name \
        -id_column span_id \
        -name_method "" 

set order 0
foreach column { 
    {priv 
        {Suppress All} {Suppress flags}
        integer integer 0 }
    {span_type
        {Span type} {Span types}
        string varchar(20) {}}
    {institution
        {Institution} {Institutions}
        string varchar(200) {} }
    {location
        {City/Country} {Locations} 
        string varchar(200) {} }
    {department
        {Department} {Department}
        string varchar(200) {} }
    {relation
        {Relation} {Relations}
        string varchar(100) {} }
    {text_date 
        {Date} {Dates}
        string varchar(100) {} }
    {started 
        {Started} {Started}
        date date {} }
    {ended 
        {Ended} {Ended} 
        date date {} }
} { 
    incr order
    foreach {attribute pretty_name pretty_plural datatype column_spec default_value} $column { break }
    
    set column_spec [subst $column_spec]

    catch { cr::content_type::create_attribute \
                -content_type $type \
                -attribute_name $attribute \
                -datatype $datatype \
                -pretty_name $pretty_name \
                -pretty_plural $pretty_plural \
                -sort_order $order \
                -default_value $default_value \
                -column_spec $column_spec } err
    ns_write "$err\n"
}

