# Create the type and attribute data 
ReturnHeaders text/plain

set type phb_address
set type_pretty "PHB Address"
set type_pretty_plural "PHB Addresss"
set table_name phb_address
ns_write "creating type $type\n"

cr::content_type::create_type \
    -content_type $type \
    -supertype content_revision \
    -pretty_name $type_pretty \
    -pretty_plural $type_pretty_plural \
    -table_name $table_name \
    -id_column address_id \
    -name_method "" 

set order 0

foreach column { 
    {priv 
        {Suppress All} {Suppress flags}
        integer integer 0}
    {address_type 
        {Address type} {Address type}
        string varchar(100) {}}
    {address_other
        {Address other} {Address others}
        string varchar(100) {}}        
    {address_1
        {Address 1} {Address 1}
        string varchar(100) {}}
    {address_2
        {Address 2} {Address 2}
        string varchar(100) {}}
    {address_3
        {Address 3} {Address 3}
        string varchar(100) {}}
    {priv_address
        {Suppress address lines} {Suppress address lines}
        integer integer 0}
    {city
        {City} {Cities} 
        string varchar(200) {}}
    {state 
        {State/Province/Region} {State/Province/Region} 
        string varchar(100) {}}
    {postcode
        {ZIP/postal code} {ZIP/postal codes}
        string varchar(25) {}}
    {country 
        {Country} {Countries} 
        string {char(2) constraint ${type}_country_fk references countries(iso)} {}}
} { 
    incr order
    foreach {attribute pretty_name pretty_plural datatype column_spec default_value} $column { break } 

    set column_spec [subst $column_spec]

    catch { cr::content_type::create_attribute \
                -content_type $type \
                -attribute_name $attribute \
                -datatype $datatype \
                -pretty_name $pretty_name \
                -pretty_plural $pretty_plural \
                -sort_order $order \
                -default_value $default_value \
                -column_spec $column_spec } err
    ns_write "$err\n"
}

