#
# Ultimately this belongs in the acs-content-repository...
#

namespace eval cr { 
    namespace eval content_type {}
    namespace eval folder {}
    namespace eval item {}
}

ad_proc -public cr::content_type::create_type { 
    -content_type 
    {-supertype content_revision}
    -pretty_name
    -pretty_plural
    -table_name 
    -id_column
    {-name_method ""}
} {
    create a content type for the content repository.

    @author Jeff Davis (davis@xarg.net)
} {
    return [db_exec_plsql create "
begin
content_type.create_type ( 
    content_type => :content_type, 
    supertype=> :supertype,
    pretty_name=> :pretty_name,
    pretty_plural=> :pretty_plural,
    table_name => :table_name, 
    id_column=> :id_column,
    name_method=> :name_method);
end;" ]
}
    
ad_proc -public cr::content_type::create_attribute { 
    -content_type
    -attribute_name
    -datatype
    -pretty_name
    -table_name 
    { -pretty_plural ""} 
    { -sort_order "" }
    { -default_value "" }
    { -column_spec "varchar(4000)" }
} { 
    Create an attribute.

    @author Jeff Davis (davis@xarg.net)
} { 
    return [db_exec_plsql create "
begin
:1 := content_type.create_attribute (
  content_type => :content_type,
  attribute_name => :attribute_name,
  datatype => :datatype,
  pretty_name => :pretty_name,
  pretty_plural => :pretty_plural,
  sort_order => :sort_order,
  default_value => :default_value,
  column_spec => :column_spec);
end;"]
} 



ad_proc -public cms_widget_register { 
    -content_type
    -attribute
    -widget
    -required:boolean
    -params
} { 
    if {![db_0or1row get_attr_id {
        select attribute_id from acs_attributes where object_type = :content_type and attribute_name = :attribute
    } ] } {
        ns_write "Attribute not found content_type $content_type attribute $attribute"
        ns_log Warning "Attribute not found content_type $content_type attribute $attribute"
        return 0 
    }

    if { $required_p } {
        set req t
    } else { 
        set req f
    } 

    # load the default set 
    db_foreach widget_params {select param as pkey, param_id, is_required, default_value from cm_form_widget_params where widget = :widget} {
        set param_arr($pkey) [list $param_id $is_required literal $default_value]
    }
    
    # override defaults for anything passed in.

    foreach param $params { 
        foreach {pkey param_source value} $param { break }
        # set values passed in.
        if {![info exists param_arr($pkey)]} { 
            ns_log Warning "widget register Invalid param: $pkey"
        } else { 
            set param_arr($pkey) [lreplace $param_arr($pkey) 1 end t $param_source $value]
        }
    }
    
    # Actually insert the param data.

    db_transaction { 
        db_dml del_params {delete from cm_attribute_widget_params where attribute_id = :attribute_id}
        db_dml del_widget {delete from cm_attribute_widgets where attribute_id = :attribute_id}
        
        db_dml ins_widget {insert into cm_attribute_widgets(attribute_id,widget,is_required) values (:attribute_id, :widget, :req)}

        foreach {pkey param} [array get param_arr] { 
            set param_type [ad_decode $pkey options multilist values onelist onevalue]

            foreach {param_id is_required param_source value} $param { break }
            
            if {[string equal is_required "t"] || ![empty_string_p $value]} { 
                db_dml ins_params {
                    insert into cm_attribute_widget_params(attribute_id, param_id, param_type, param_source, value) 
                    values (:attribute_id, :param_id, :param_type, :param_source, :value)
                }
            }
        }
    }
}


ad_proc -public cr::folder::new { 
    -name
    -label
    -description
    {-parent_id {}}
} { 
    Create a folder 
} {    
    ns_log Debug "cr::folder::new name $name label $label is $description"

    if { [ad_conn isconnected] } { 
        set user_id [ad_conn user_id]
        set ip [ad_conn peeraddr]
    } else { 
        set user_id 0 
        set ip 127.0.0.1
    } 

    return [ db_exec_plsql new_folder "
    begin
    :1 := content_folder.new(
        name          => :name,
        label         => :label,
        description   => :description,
        parent_id     => :parent_id,
        creation_user => :user_id,
        creation_ip   => :ip );
    end;" ]

} 

ad_proc -public cr::folder::register_content_type {
    -folder 
    -content_type 
    -include_subtypes:boolean
} { 
    register a content type to a folder.
    
    @param folder the folder id for the target folder
    @param content_type the content_type string 
} { 
    ns_log Debug "cr::folder::register_content_type registering $content_type to $folder (include subtypes? $include_subtypes_p)"
    
    if {$include_subtypes_p} { 
        set inc t 
    } else { 
        set inc f
    }


    db_exec_plsql register_content_type "
          begin
          content_folder.register_content_type(
              folder_id        => :folder,
              content_type     => :content_type,
              include_subtypes => :inc
          );
          end;"

    cms_folder::flush_registered_types $folder
} 

ad_proc -public cr::content_type::register_relation { 
    {-type child_rel}
    -content_type
    -target_type
    -relation 
    {-min 0}
    {-max {}}
} { 
    Register a valid relation 
    
    @param type child or item
    @param content_type the parent content type
    @param target_type the child content type
    @param relation the tag for the relation
    @param min the minimum number of relations of the given type. default none.
    @param max the maximum allowable related object.  default unlimited.
} { 
    ns_log Debug "cr::content_type::register_relation register $type relation tag $relation from $content_type to $target_type"

    if { [string equal $type item_rel] } {
        set register_method "register_relation_type"
        set content_key "content_type"
        set target_key "target_type"

    } elseif { [string equal $type child_rel] } {
        set register_method "register_child_type"
        set content_key "parent_type"
        set target_key "child_type"
    }

    if { [catch {db_exec_plsql register_rel_types "
          begin
          content_type.${register_method} (
              $content_key => :content_type,
              $target_key  => :target_type,
              relation_tag => :relation,
              min_n        => :min,
              max_n        => :max
          );
          end;"} errmsg] } {
        ns_log Error "Could not register relation type - $errmsg"
    }
}

ad_proc -public cr::item::set_latest_revision_live { 
    -item_id 
} { 
    sets the latest revision of the given item_id to the live revision 

    @author Jeff Davis (davis@xarg.net)
} { 
    # Do a little checking before we call the plsql
    if {![string is integer $item_id]} { 
        error "cr::item::set_live_revision item_id $item_id is not a number"
    } 
    
    db_exec_plsql set_live_revision "
     begin
       content_item.set_live_revision(
         content_item.get_latest_revision( item_id => :item_id )
       );
     end;"
}

