create or replace view phb_portraits as 
select i.item_id, i.name as user_key, i.parent_id as folder_id, 
              nvl(p.preferred_name,p.first_name) as first_name, 
              p.last_name, p.user_id, p.priv,p.priv_portrait,
              rel.relation_tag, 
              imi.item_id as image_id, imi.live_revision as image_revision_id,
              imr.mime_type, imr.filename, 
              o.creation_date, o.creation_ip, o.creation_user,
              im.width, im.height 
from cr_items i, phb_person p, cr_child_rels rel, cr_items imi, cr_revisions imr, images im, acs_objects o
        where i.live_revision = p.person_id 
          and rel.parent_id = i.item_id
          and imi.item_id = rel.child_id
          and imr.revision_id = imi.live_revision
          and im.image_id = imr.revision_id
    and o.object_id = imr.revision_id;

update acs_attributes set pretty_name = 'EFL Forwarding',
PRETTY_PLURAL = 'EFL Forwarding' where pretty_name = 'Outside email';