if {![info exists user]} { 
    ad_page_contract { 
        Display the data for one or more Photobook persons.
    
        By default the viewers own data is displayed
        and no privacy suppression is carried out.

    } {
        {user:integer {}}
        {mode:trim general} 
        {public 0} 
        {return_url ""}
        {return_page ""}
    }
}

set my_user_id [phb::dispatch -user_id $user]

set admin_p [permission::permission_p -party_id $my_user_id -object_id [ad_conn package_id] -privilege admin]
if {![exists_and_not_null public]} { 
    set public 0
}


#  propigate the public data display status 
set link_suffix {}
if {$public} { 
    append link_suffix "?public=1"
} 

# propigate the return_url
if {[exists_and_not_null return_url]} { 
    if {![exists_and_not_null return_page]} { 
        set return_page "Back"
    }
    if {![string is space $link_suffix]} { 
        append link_suffix "&[export_vars -url {return_url return_page}]"
    } else { 
        set link_suffix "?[export_vars -url {return_url return_page}]"
    } 
} else { 
    set return_url {}
    set return_page {}
}



set suppress_data [expr !(!$public && ($admin_p || [string equal $user $my_user_id] ))]

set childlist [phb::users_items -user_ids $user]
#ns_log Notice "JCD: childlist: '$childlist'"

#
# Pull out all the data for a user list.
#

# First get the default account data for the set of users.


# How many items can we get with a single in clause...
set max_in_items 1000

set user_count [llength $user]

if {!$user_count} { 
    ns_returnnotfound
    ad_script_abort
} 

for {set i 0} {$user_count > [expr {$i * $max_in_items}]} {incr i} {
    array unset user_role
    set user_list {}
    set pre {}

    foreach a_user [lrange $user [expr $i * $max_in_items] [expr {($i + 1) * $max_in_items - 1}]] {
        append user_list "$pre[lindex $a_user 0]"
        set user_role([lindex $a_user 0]) [lindex $a_user 1]
        set pre ", "
    }

    db_multirow -append=[expr $i > 0] -extend role phb_all get_user_defaults "select c.user_id as def_user_id, 
             c.first_names as def_first_name,
             c.last_name as def_last_name,
             c.email as def_outside,
             c.url as user_url, 
             c.creation_date,
             c.member_state, 
             s.efl, s.alias, s.outside, 
             decode(p.mime_type,'image/jpeg','jpg','image/gif','gif',decode(p.relation_tag,null,'','jpg')) as image_type
      FROM cc_users c, sloan_email s, phb_portraits p
      WHERE c.user_id in (${user_list})
        and s.user_id(+) = c.user_id
        and p.user_id(+) = c.user_id 
        and p.relation_tag(+) = 'portrait_web'
       order by upper(c.last_name), upper(c.first_names)" \
        {
            set role $user_role($def_user_id)
        }
                    
}
  

if {![multirow size phb_all]} { 
    ns_returnnotfound
    ad_script_abort
}

# build a list of the types the given user has 
#

foreach {tag val} $childlist { 
    set type [lindex [split $tag .] 0]
    if {![empty_string_p $val]} { 
        if {[info exists ids($type)]} {
            set ids($type) [concat $ids($type) $val]
        } else { 
            set ids($type) $val
        } 
    } else { 
        ns_log Debug "JCD: dummy for $type"
        template::multirow create $type dummy 
    } 
} 

ns_log Debug "JCD: types  [array name ids]"

# actually pull out the data 
# 
foreach type [array name ids] { 
    if {[string equal image $type] || ![llength $ids($type)]} {
        # Do not retrieve images or things with no rows.
    } else { 
        for {set i 0} {[llength $ids($type)] > [expr {$i * $max_in_items}]} {incr i} {
            db_multirow -append=[expr $i > 0] $type get " 
            SELECT i.parent_id, r.relation_tag, t.item_id, t.revision_id, t.name, [join [phb::type_attributes $type] ", "]
              FROM ${type}x t, cr_items i, cr_child_rels r
             WHERE t.item_id in ([join [lrange $ids($type) [expr $i * $max_in_items] [expr {($i+1)*$max_in_items - 1}]] ", "]) 
               and t.revision_id = i.latest_revision
               and r.parent_id(+) = i.parent_id 
               and r.child_id(+) = i.item_id" \
                { 
#		    ns_log Notice "JCD: parent_priv($item_id) = '$priv', type = '$type', name = '$name'"
                    set parent_priv($item_id) $priv
                } 
        }
    }
}

set url [apm_package_url_from_key photobook]

# Priv mask the data.
# 
# Data is suppressed based on the value of privacy flags
# privacy flags are fields which are named priv*
# phb_person contains the majority of these fields
# priv -- global privacy flag
# priv_* category and specific field flags
# The below code does not work on categories only global and specific fields
# Example
# phb_person.priv_child 
# if this is set to 10 it means private.
# a regexp in phb::mask_private_attrs removes the priv_ leaving child
# all fields which match child* will be masked
# this would include child_1, child_2, etc.
# 
# Some other tables have priv flags. 
# Same rules apply here as well.
#
# Categroy Suppression
# Example priv_education
# The code below would look for fields education*
# but wouldn't find any so it doesn't handle category suppression
# Category suppression is handled in the csv code by one method
# and it is handled in the web display by disallowing access to pages
# which display the information. It isn't completely clear that these
# two methods produce identical results. 
# Categories seem to cross database tables and even apply to some rows
# of some tables, but not to others depending on the values of that row
# Example: a phb_span might be employment or education. This makes it 
# very difficult to apply category suppression in a consistent way. 
# BEGIN GLOBAL AND FIELD SUPPRESSION
if { $suppress_data } { 
    foreach type [array name ids] { 
        if {![string equal image $type] && [llength $ids($type)]} {
            set size [template::multirow size $type]
            for {set i 1} {$i <= $size} {incr i} { 

                # We need to pull out the parent priv for the current row 

                set parent [multirow get $type $i parent_id]

                if {[info exists parent_priv($parent)]
                    && ![empty_string_p $parent_priv($parent)]
                } { 
                    set override $parent_priv($parent)
                }  else {
                    set override 0
                } 

                set excludes {item_id relation_tag parent_id}
                if {[string equal $type phb_person]} { 
                    lappend excludes first_name last_name user_id
                } 
                # actually apply the masks.
                phb::mask_private_attrs -override $override \
                    -excludes $excludes \
                    $type:$i [phb::private_flags $type]
            }
        }
    }
}
# END GLOBAL AND FIELD SUPPRESSION (CATEGORY SUPPRESSION BELOW IN CSV CODE)

# Tack person data onto the defaulted user data
#

eval template::multirow extend phb_all [phb::type_attributes phb_person] item_id private_p photobook_user

for {set i 1} {$i <= [multirow size phb_all]} {incr i} { 
    set found_p 0 
    for {set j 1} {$j <= [multirow size phb_person]} {incr j} { 
        if {[set phb_all:${i}(def_user_id)] == [set phb_person:${j}(user_id)]} { 
            set found_p 1
            array set phb_all:${i} [array get phb_person:${j}]
            set phb_all:${i}(photobook_user) 1
            if {[exists_and_not_null phb_all:${i}(priv_$mode)]} { 
                set phb_all:${i}(private_p) [expr {[set phb_all:${i}(priv)] || [set phb_all:${i}(priv_$mode)]}] 
            } else { 
                set phb_all:${i}(private_p) [set phb_all:${i}(priv)]
            } 
            foreach var {first_name last_name} {
                if {![exists_and_not_null phb_all:${i}($var)]} { 
                    set phb_all:${i}($var) [set phb_all:${i}(def_$var)]
                } 
            }
            break
        } 
    } 
    if {!$found_p} { 
        foreach var {user_id first_name last_name outside} {
            set phb_all:${i}($var) [set phb_all:${i}(def_$var)]
        }
        foreach var {salutation} { 
            set phb_all:${i}($var) {}
        } 
        
        foreach var {private_p photobook_user} {
            set phb_all:${i}($var) 0
        } 
    }
}


# Add any synthetic fields...
#
#


set i 0
template::multirow extend phb_all formal_name full_name short_name children languages outside_interests academic_interests image_file
template::multirow foreach phb_all { 
    incr i
    set formal_name [join [list $first_name $middle_name $last_name] " "]
    set full_name [join [list $first_name $last_name] " "]

    set short_name "[ad_decode $preferred_name {} $first_name $preferred_name] $last_name"

    foreach j {1 2 3 4 5} {
        if {![string is space [set child_$j]]
            && [string is integer [set child_born_$j]]
            && ![string is space [set child_born_$j]]} { 
            set child_age [max 1 [expr [clock format [clock seconds] -format %Y] - [set child_born_$j]]]
            append phb_all:${i}(child_$j) " ($child_age)"
        } 
    }
    set children [phb::join_array phb_all:$i child]
    set languages [phb::join_array phb_all:$i language]
    set outside_interests [phb::join_array phb_all:$i outside_interest]
    set academic_interests [phb::join_array phb_all:$i academic_interest]

    set origin [phb::get_country_name $origin]
    set citizenship [phb::get_country_name $citizenship]    
    if {![empty_string_p $alias]} { 
        set email_primary $alias@sloan.mit.edu
        if {![empty_string_p $image_type]} { 
            set image_file "${alias}.$image_type"
        } 
    } else { 
        set email_primary $def_outside
        if {![empty_string_p $image_type]} { 
            set image_file "[string map {@ _ . _} $def_outside].$image_type"
        } 
    } 
    
    if {![empty_string_p $efl]} { 
        set email_efl $efl@sloan.mit.edu
    }

    set email_outside $outside
    if {![empty_string_p $birthdate]} { 
        set birthdate [clock format [clock scan $birthdate] -format "%m/%d/%y"]
    } 
    
    # extra precaution to make sure institute_id is not available to unauthorized users.
    if { $suppress_data } { 
        set institute_id {}
    } 
    
    # The filename for the dumped file when downloading
    
}


template::multirow extend phb_phone full_number
template::multirow foreach phb_phone { 
    # need to prepend a single quote for CSV files, to handle leading +
    if { $mode == "csv" } {
      set full_number "'"
    } else {
      set full_number ""
    }
    set full_number [append full_number [phb::full_number $country_code $area_code $phone_number $extension]]
}

template::multirow foreach phb_address { 
    if {![string equal $country US]} { 
        set country [phb::get_country_name $country]
    } 
}

template::multirow extend phb_span dates
template::multirow foreach phb_span { 
    set dates [phb::span_dates $started $ended]
}

if {[multirow size phb_all] == 1
    && [lsearch {facebook thumbnail general csv} $mode] == -1
    && ( [string equal [multirow get phb_all 1 priv] 0] 
         || ! $suppress_data)
} { 
    set nav_p 1

    multirow create nav formkey name tip vtip title
    
    multirow append nav p main {} {main} Profile
    
    foreach {formkey name tip vtip title} { 
        p personal {Edit personal data} {View personal data} {Personal profile}
        m employment {Edit employment history} {Edit employment history} {Employment history}
        a address {Edit address data} {View address data} {Contact details} 
        e education {Edit educational history} {View educational history} {Educational history} 
    } {
        if {! $suppress_data
            || [string equal [multirow get phb_all 1 priv_$name] 0]
         } {
            multirow append nav $formkey $name $tip $vtip $title
        } 
    } 

    if { $admin_p } { 
        multirow append nav z admin {Edit Administrative data} {View administrative data} {Administrative data}
    }
} else { 
    set nav_p 0
} 

# _dq means double double quote. replace " with ""
proc _dq str { 
    if {![string is alnum $str]} {
        return "\"[string map {{"} {""}} $str]\""
    } else { 
        return $str
    }
}

#  
# CSV Handling
#

# Are we generating a csv file?  If so process all the information

if {[string equal $mode csv]} { 
    if {[string equal $csvtype full]} { 
        # The csvrel for a full dump 

        set csvrel { 
            phb_person {} {
                formal_name formal_name
                short_name short_name
                first_name first_name
                middle_name middle_name
                last_name last_name
                suffix suffix
                preferred_name preferred_name
                former_name former_name
                efl "EFL"
                alias "Alias"
                outside "Outside_email"
                email_primary email_primary
                academic_interest_1 academic_interest_1              
                academic_interest_2 academic_interest_2
                academic_interest_3 academic_interest_3
                birthdate birthdate
                child_1 child_1
                child_2 child_2
                child_3 child_3
                child_4 child_4
                child_5 child_5
                child_born_1 child_born_1
                child_born_2 child_born_2
                child_born_3 child_born_3
                child_born_4 child_born_4
                child_born_5 child_born_5
                citizenship citizenship
                class_year class_year
                concentration_1 concentration_1
                concentration_2 concentration_2
                ethnicity ethnicity
                expected_graduation expected_graduation
                favorite_book favorite_book
                favorite_movie favorite_movie
                favorite_place favorite_place
                gender gender
                hometown_city hometown_city
                hometown_country hometown_country
                hometown_postcode hometown_postcode
                hometown_state hometown_state
                institute_id institute_id
                language_1 language_1
                language_2 language_2
                language_3 language_3
                living_group living_group
                marital_status marital_status
                one_word_description one_word_description
                origin origin
                outside_interest_1 outside_interest_1
                outside_interest_2 outside_interest_2
                outside_interest_3 outside_interest_3
                partner_firstname partner_firstname
                partner_lastname partner_lastname
                past_employers past_employers
                preferred_graduation preferred_graduation
                program program
                salutation salutation
                status status
                status_note status_note
                urop_1 urop_1
                urop_2 urop_2
                photobook_user photobook_user
                children children
                languages languages
                outside_interests outside_interests
                academic_interests academic_interests
                image_file image_file
            }
            phb_phone home {full_number "Home_Number"}
            phb_phone mobile {full_number "Mobile_Number"}
            phb_span degree { 
                institution "University" 
                department "Major"
                relation "Degree" 
                dates "Attended"
                started "Started"
                ended "Ended"
            }
            phb_span internship {
                institution "Company"
            }
            phb_span job_current { 
                institution "Employer"
                location "Location"
                relation "Position"
            } 
            phb_span job_past { 
                institution "Employer"
                location "Location"
                relation "Position"
            } 
            phb_address hometown { 
                address_1 "Address_1"
                address_2 "Address_2"
                address_3 "Address_3"
                city "City" 
                state "State/Province"
                postcode "ZIP"
                country "Country"
            }
            phb_address address { 
                address_1 "Address_1"
                address_2 "Address_2"
                address_3 "Address_3"
                city "City" 
                state "State/Province"
                postcode "ZIP"
                country "Country"
            } 
        }    
        
    } else { 
        
        # The default set of data to display 
        
        set csvrel { 
            phb_person {} { 
                email_primary email_primary 
                preferred_name preferred_name
                first_name first_name
                middle_name middle_name
                last_name last_name  
                suffix suffix
            } 
        }
    }

    foreach t {phb_phone phb_address phb_span} { 
        set rownum 0
        multirow foreach $t { 
            incr rownum
            if {[info exists $t:${relation_tag}($parent_id)]} { 
                lappend "$t:${relation_tag}($parent_id)" $rownum 
            } else { 
                set "$t:${relation_tag}($parent_id)" $rownum                 
            } 
        } 
    } 


    set csvcols ""
    
    for {set i 1} {$i <= [multirow size phb_all]} {incr i} {
	set pre {}
        # get the phb_person array 
        multirow get phb_all $i 
        upvar 0 phb_all phb_person

        foreach {_type _relation _fields} $csvrel {
            if {![string equal $_type phb_person]} { 
                if {[info exists $_type:${_relation}($phb_person(item_id))]} { 
                    set rows [set $_type:${_relation}($phb_person(item_id))]
                } else {
                    set rows 0
                } 
                if {[string equal $_type phb_span] 
                    && [string equal $_relation degree]
                    && [llength $rows] < 4
                } { 
                    set rows [concat $rows [lrange {0 0 0 0} 0 [expr 3 - [llength $rows]]]]
                } 
            } else {
                set rows $i
            } 
            
            # loop over rows and output data 
            set relnum {}
            foreach row $rows { 
                if {![string equal $_type phb_person]} { 
                    if {!$row} { 
                        array unset $_type
                    } else { 
                        multirow get $_type $row
                    } 
                } 
                # FIELD AND CATEGORY PRINT OR SUPPRESSION CODE
                # Note: this might be movable to when the row is upvar'd
                # then do one if per category and search for category fields.
                foreach {_field _tag} $_fields { 
                    if {$i == 1} { 
                        if {[string equal $_relation {}]} { 
                            append csvcols "$pre[_dq $_tag]"
                        } else { 
                            append csvcols "$pre[_dq $_relation$relnum:$_tag]"
                        } 
		    } 
                    if {![info exists "${_type}($_field)"]} {
                        set output "$pre"
                        # repeat result of this loop and exit now
                        append csvout $output
                        set pre ,
                        continue
		    } else { 
			# default append
			set output "$pre[_dq [set ${_type}($_field)]]"
                    }
                    # If not suppressing output, append and continue
                    if { ! $suppress_data } {
                       append csvout $output
                       set pre ,
                       continue 
                    } 
		    # Maybe adjust output
		    # we have four category flags:
		    # 1. priv_personal -- all in phb_person minus a few default fields
		    # 2. priv_education -- phb_span degree + phb_person academic_interests?
		    # 3. priv_employment -- phb_span job_past, job_current, internship
		    # 4. priv_address -- phb_address + some of phb_person
		    switch -- $_type {
			phb_person {
			    if {[string match "10" $phb_all(priv_personal)]} {
				if {[lsearch [list email_primary efl first_name \
                                        middle_name last_name suffix formal_name short_name outside ] \
					$_field] == -1 } {
				    set output "$pre"
				}
			    }
			    if {[string match "10" $phb_all(priv_address)]} {
				if {[lsearch \
					 [list hometown_city hometown_country \
					      hometown_postcode hometown_state] \
					 $_field] > -1} {
				    set output "$pre"
				}
			    }
			    if {[string match "10" $phb_all(priv_employment)]} {
				if {[lsearch [list past_employers] $_field] > -1} {
				    set output "$pre"
				}
			    }
			    if {[string match "10" $phb_all(priv_education)]} {
				if {[lsearch [list academic_interest_1 academic_interest_2 \
						  academic_interest_3 concentration_1 \
						  concentration_2 expected_graduation \
						  preferred_graduation program \
						  academic_interests] $_field] > -1} {
				    set output "$pre"
				}
			    }
						  
			}
			phb_phone {
			    # only priv_address
			    if {[string match "10" $phb_all(priv_address)]} {
				set output "$pre"
			    }
			}
			phb_span {
			    if {[string match "10" $phb_all(priv_employment)]} {
				if {[lsearch [list job_past job_current internship] $_relation] > -1} {
				    set output "$pre"
				}
			    }
			    if {[string match "10" $phb_all(priv_education)]} {
				if {[string equal "$_relation" degree]} {
				    set output "$pre"
				}
			    }
			}
			phb_address {
			    if {[string match "10" $phb_all(priv_address)]} {
				set output "$pre"
			    }
			}
			
		    }
		    
		    append csvout $output
		    set pre ,
                }
                # END CATEGORY SUPPRESSION CODE 
                if {[string equal $relnum {}]} { 
                    set relnum 0
                } 
                incr relnum
            }
        }
        append csvout "\r\n"
    }

    ns_return 200 application/csv "$csvcols\r\n$csvout"
    
    ad_script_abort
} 
