set community_id [dotlrn_community::get_community_id]

if {![exists_and_not_null referer]} { 
    set referer {}
}

if {![exists_and_not_null page]} { 
    set page 1
} 



if {[exists_and_not_null return_url]} {     
    if {![exists_and_not_null return_page]} {     
	set return_page Back
    }
} else { 
    set return_url {}
    set return_page {}
}

db_foreach users {
    select registered_users.user_id, role, last_name, rel_type
    from registered_users,
    dotlrn_member_rels_approved
    where dotlrn_member_rels_approved.community_id = :community_id
      and dotlrn_member_rels_approved.user_id = registered_users.user_id 
    order by decode(role,
                    'instructor',1,
                    'admin',2,
                    'teaching_assistant',3,
                    'course_assistant',4,
                    'course_admin',5,
                    'student',6,
                    'member',7), last_name, first_names
} { 
    set role [dotlrn_community::get_role_pretty_name -community_id $community_id -rel_type $rel_type]
    lappend users [list $user_id $role $last_name]
}

set size 10

phb::pagination pages $users $size $page

# Generate prev next links 
# 
if {$page > 1} { 
    set prev_page [expr $page - 1]
} 

if {[expr $page * $size] < [llength $users]} { 
    set next_page [expr $page + 1]
} 
    
# Pull out just the users we want to display
# 
set start [expr {($page - 1)*$size}]
set end [expr $start + $size - 1]
set users [lrange $users $start $end]
