<master>
  <property name="title">@title;noquote@</property>
  <property name="signatory">@signatory;noquote@</property>
  <property name="context_bar">@context_bar;noquote@</property>
  <property name="header_stuff"><link href="index.css" type="text/css" rel="stylesheet"></property>

  <h2>Why</h2>

  <p>@package_name@ was created to publish the conversation logs of
  the <a href="irc::/irc.freenode.net/#openacs" title="Direct link to
  the #openacs channel. Does not work in all browsers.">#openacs</a>
  IRC channel at <a href="http://openacs.org" title="Home of the Open
  Architecture Community System">OpenACS</a> in a way that allowed the
  logs to be indexed and subject to the OpenACS permission system.</p>

  <h2>Background</h2>

  <p>While Dave Beckett's <a
  href="http://cvs.ilrt.org/cvsweb/redland/logger/">IRC Chat
  logger</a> also can generate a HTML log @package_name@ improves upon
  Dave's logger in several ways:</p>

  <ol>
    <li>By transforming the RDF log to HTML one is free to create HTML logs in any format desired.</li>
    
    <li>Once transformed to HTML the log is stored in an <a
        href="http://openacs.org/doc/edit-this-page/">Edit-This-Page</a>
        page which allows selective permissions on the log and
      causes the log to be indexed by the site's search engine.</li>

    <li>Furthermore placing the log in an Edit-This-Page page the
      log encapsules the log with the master template of site.</li>

  </ol>

  <h2>Installation</h2>

  <p class="note">Note: This release has been developed on PostgreSQL
    only. Please report any problems you might find in the <a
    href="http://openacs.org/bugtracker/">OpenACS bugtracker</a>. The
    bugtracker can also be used to contribute patches to the
    @package_name@ package (for example to add Oracle support).</p>

  <p>The @package_name@ requires <a
    href="http://www.tdom.org/">tDOM</a> and Edit-This-Page to be
    installed. tDOM provides the XML parsing and XSLT capabilities
    that @package_name@ relies upon. Please follow the installation
    instructions included with tDOM. Edit-This-Page is another OpenACS
    module and is available from <a
    href="http://openacs.org/">OpenACS</a>.</p>

  <p>Included with @package_name@ is a <i>modified</i> copy of Dave
    Beckett's RDF IRC Chat Logger. Dave's Perl script has been
    modified to allow the bot to respond in private to messages
    originating in the public channel. The logger script is located in
    the perl directory of @package_name@, type <code>./logger
    --help</code> for a complete list of command line options.</p>

  <p>During the development of @package_name@ <a
      href="http://wwww.thecodemill.biz">the Code Mill</a> used the
    following parameters to start logging</p>
  <blockquote><pre><code>
logger \ 
-nick eavesdrop \ 
-lroot /web/thecodemill/data/eavesdrop/log/ \ 
-log %Y-%m-%d \ 
-admin /web/thecodemill/data/eavesdrop/admin/ \ 
-uroot "http://www.thecodemill.biz/irc/log/" \ 
bla irc://irc.freenode.net/openacs
      </code></pre></blockquote>

  <p>Place logger under supervision using <a
  href="http://cr.yp.to/daemontools.html">daemontools</a> or crontab
  to guarantee that the bot stays connected to the IRC channel it is
  logging.</p>

  <p class="note">Check this <a
      href="http://groups.google.com/groups?q=irc+perl+connection.pm&hl=en&lr=&ie=UTF-8&oe=UTF-8&safe=off&selm=befb49b6.0106160819.201cabdf%40posting.google.com&rnum=3">usenet
      message</a> should you be experiencing problems with the perl
      package <a href="http://search.cpan.org/author/JEEK/Net-IRC-0.73/IRC.pm">Net::IRC</a> which logger depends on.</p>
  
  <p>With tDOM installed and logger connected to the IRC channel it is
    time to mount and configure @package_name@.</p>

  <h2>Usage</h2>

  <ol>
    <li>Mount @package_name@ directly under an instance of
      Edit-This-Page. E.g. if /irc/log/ is an instance of
      Edit-This-Page then mount @package_name@ at /irc/log/logger/.</li>

    <li>Configured @package_name@. Configuration is via <a
        href="/admin/site-map/">@package_name@ parameters</a>. The package
      has 4 parameters:

      <ol>
        <li>

          <h3>irc_channel_name</h3>

          <p>The name of the IRC channel being logged. This should match
            the name of the IRC channel that the Perl logger script is
            logging. E.g. #openacs</p>
          
        </li>
        <li>
          
          <h3>xsl_stylesheet</h3> 
          
          <p>The full path to the XSL stylesheet to be used to transform
            the RDF log into HTML. The default.xsl stylesheet in the data
            directory of the @package_name@ package will be used if no
            value is specified.</p>
          
        </li>
        <li>
          
          <h3>irc_rdf_dir</h3>

          <p>The full path to the directory containing the logger RDF
            files. This is the directory that the Perl logger script writes
            the RDF (and text) log files to. E.g. /web/thecodemill/data/eavesdrop/log/</p>

        </li>
        <li>

          <h3>irc_log_interval</h3>

          <p>The interval (in seconds) with which IRC Logger should
            check for changes in the current RDF file. The default is
            300 seconds (or 5 minutes).</p>

        </li>
      </ol>
    </li>
  </ol>

  <p>Last but not least, restart AOLserver to start scheduled
    procedure <a
    href="/api-doc/proc/irc::logger::scheduled_update">irc::logger::scheduled_update</a>
    that checks for updates of today's IRC log and puts an
    Edit-This-Page page of the log directly under the instance of
    Edit-This-Page that @package_name@ is mounted under.</p>

  <p>@package_name@ can be mounted more than once. Each instance
    processing the logs of a different bot. New logs are added to the
    top of the page, preceded by a link called 'current' which is a
    symlink to the latest IRC log.</p>

  <p>There is an additional 'current' link in @package_name@ for ease
    of linking to the latest IRC log from other packages or from
    external sites. This additional link is necessary because the
    'current' link on the page listing the IRC logs can not be
    referred to as /irc/log/current. Edit-This-Page does not redirect
    the request for /irc/log/current to the latest log but produces a
    '404 Page not found' error instead. Hence the additional 'current'
    link at /irc/log/logger/current.</p>

  <p>@package_name@ will link to the user's profile and include the
    full name for users of the site who have entered their IRC nick as
    their OpenACS <a href="@pvt_home@">screen name</a>.</p>

  <h2>Credits</h2>

  <p>The @package_name@ was designed and written by <a
      href="mailto:bart.teeuwisse@thecodemill.biz">Bart Teeuwisse</a>
      of <a href="http://www.thecodemill.biz">the Code Mill</a> for <a
      href="http://openacs.org">OpenACS</a>.</p>

  <p>The @package_name@ is free software; you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.</p>

  <p>The @package_name@ is distributed in the hope that it will be
    useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.</p>

  <p>A <a href="license">copy of the GNU General Public License</a> is
    included. If not write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
