ad_page_contract {

    @author Bart Teeuwisse (bart.teeuwisse@thecodemill.biz)
    @creation-date 2003-02-10
    @cvs-id $Id: update.tcl,v 1.3 2003/02/13 04:03:53 bartt Exp $

} {
    date:notnull
}

# Authenticate the user

set user_id [ad_maybe_redirect_for_registration]

# Check for admin privileges

set package_id [ad_conn package_id]
set admin_p [ad_permission_p $package_id admin]

foreach rdf_log [glob -nocomplain -directory [parameter::get \
                                                  -parameter irc_rdf_dir \
                                                  -package_id $package_id \
                                                  -default ""] $date.rdf] {

    # Touch the log file so that irc::logger::update_log will process
    # the log.

    exec touch $rdf_log

    # Update the ETP page of the log.

    irc::logger::update_log -date [file rootname [file tail $rdf_log]] -package_id $package_id

}

# Return to the main admin page

ad_returnredirect .?[export_vars -url {{updated $date}}]
