ad_page_contract {
    
    Provide a link to the package parameters of this instance of IRC
    Logger.

    @author Bart Teeuwisse (bart.teeuwisse@thecodemill.biz)
    @creation-date 2003-01-29
    @cvs $Id: index.tcl,v 1.3 2003/02/11 21:49:54 bartt Exp $
} {
    {updated {}}
} -properties {
    title:onevalue
    rdf_dir:onevalue
    rdf_logs:multilist
}

# Authenticate the user

set user_id [ad_maybe_redirect_for_registration]

# Check for admin privileges

set package_id [ad_conn package_id]
set package_key [ad_conn package_key]
set admin_p [ad_permission_p $package_id admin]

# Get the package name and set the title.

if {[db_0or1row get_package_name "
    select p.instance_name 
    from apm_packages p, apm_package_versions v
    where p.package_id = :package_id
    and p.package_key = v.package_key
    and v.enabled_p = 't'"]} {
    set title "$instance_name Administration"
} else {
    set title "Administration"
}

# Create a data source of remaining RDF log files in the log directory

multirow create rdf_logs desc date view_href update_href
set rdf_dir [parameter::get \
                 -parameter irc_rdf_dir \
                 -package_id $package_id \
                 -default ""]

# First a link to update all RDF log files.

multirow append rdf_logs "All RDF log files" "*" {} update?[export_vars -url {{date *}}]

# Followed by links to individual RDF log files.

foreach rdf_log [glob -nocomplain -directory $rdf_dir *.rdf] {
    set date [file rootname [file tail $rdf_log]]
    if {[file writable $rdf_log]} {
        multirow append rdf_logs $date $date ../../$date update?[export_vars -url {date $date}]
    } else {
        multirow append rdf_logs $date $date ../../$date {}
    }
}
