<?xml version="1.0"?>
<queryset>

  <rdbms>
    <type>postgresql</type>
    <version>7.1</version>
  </rdbms>

  <fullquery name="irc::logger::rotate_logs.get_parent_id">
    <querytext>
      select etp__get_folder_id(:package_id)
    </querytext>
  </fullquery>

  <fullquery name="irc::logger::rotate_logs.etp_logs">
    <querytext>
      select i1.item_id, i1.tree_sortkey, coalesce((
      	select tree_sortkey 
      	from cr_items i2 
      	where i2.tree_sortkey > i1.tree_sortkey 
      	and i2.parent_id = :parent_id 
        and i2.name <> 'index'
        and $i2_select_criteria
      	order by i2.tree_sortkey limit 1), (
      	select i2.tree_sortkey 
      	from cr_items i2
      	where i2.parent_id = :parent_id
        and i2.name <> 'index'
        and $i2_select_criteria
      	order by i2.tree_sortkey limit 1)) as next_sortkey
      from cr_items i1
      where i1.parent_id = :parent_id 
      and i1.name <> 'index'
      and $i1_select_criteria
      order by i1.tree_sortkey;
    </querytext>
  </fullquery>

  <fullquery name="irc::logger::update_log.page_create">
    <querytext>
      select etp__create_page(:parent_package_id, :date, :date, :content_type)
    </querytext>
  </fullquery>

  <fullquery name="irc::logger::update_log.create_extlink">
    <querytext>
      select etp__create_extlink(:parent_package_id, :log_url, :link_label, :link_description);
    </querytext>
  </fullquery>

  <fullquery name="dom::xpathFunc::irc::logger::user_link.get_user">
    <querytext>
      select u.user_id, p.first_names || ' ' || p.last_name as name 
      from users u, persons p 
      where u.screen_name = :nick
      and p.person_id = u.user_id
      limit 1
    </querytext>
  </fullquery>

</queryset>
