<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:wn="http://xmlns.com/wordnet/1.6/"
  xmlns:foaf="http://xmlns.com/foaf/0.1/"
  xmlns:irc="irc::logger"
  exclude-result-prefixes="xsl rdf dc wn foaf irc">
  
  <!-- Process each ChatChannel in the RDF file -->
  <xsl:template match="foaf:ChatChannel">
    <xsl:apply-templates/>
  </xsl:template>

  <!-- Create table per ChatChannel listing the events -->
  <xsl:template match="foaf:chatEventList">
    <table>
      <tbody>
        <xsl:apply-templates/>
      </tbody>
    </table>
  </xsl:template>

  <!-- One event per table row, listing date/time, nick and event description. -->
  <xsl:template match="foaf:chatEvent">
    <tr>
      <td nowrap="true" valign="top">
        <a name="{@rdf:ID}">
          <xsl:apply-templates select="dc:date"/>
        </a>
      </td>
      <xsl:apply-templates select="dc:creator/wn:Person"/>
      <xsl:apply-templates select="dc:description"/>
    </tr>
  </xsl:template>

  <!-- Display the time only but with the full date/time in the
       title. The title pops up in tooltip when the mouse pointer
       rests on the time. -->
  <xsl:template match="dc:date">
    <xsl:variable name="formatted_date"><xsl:value-of select="translate(.,'TZ',' ')"/> GMT</xsl:variable>
    <font size="-1" color="grey" title="{$formatted_date}">[<xsl:value-of select="substring-before(substring-after(.,'T'), 'Z')"/>]</font>
  </xsl:template>

  <!-- List the nick with a link to the OpenACS account if there is
       an account with screen name 'nick'. -->
  <xsl:template match="dc:creator/wn:Person">
    <td align="right" valign="top">
      <font color="grey">&lt;</font>
      <b><xsl:value-of select="irc:user_link(@foaf:nick)" disable-output-escaping="yes"/></b>
      <font color="grey">&gt;</font>
    </td>
  </xsl:template>

  <!-- Parse the description -->
  <xsl:template match="dc:description">
    <td valign="top">
      <xsl:choose>

        <!-- Display users joining/leaving less prominent -->
        <xsl:when test="contains(.,'has joined #openacs') or contains(.,'has left #openacs')">
          <font color="grey"><xsl:value-of select="."/></font>
        </xsl:when>

        <!-- Make http: links active hyperlinks -->
        <xsl:when test="contains(.,'http:')">
          <xsl:if test="contains(substring-after(.,'http:'),' ')">
            <xsl:value-of select="substring-before(.,'http:')"/>
            <a href="http:{substring-before(substring-after(.,'http:'),' ')}">http:<xsl:call-template name="split_string">
                <xsl:with-param name="string" select="substring-before(substring-after(.,'http:'),' ')"/>
              </xsl:call-template>
            </a>
            <xsl:value-of select="concat(' ',substring-after(substring-after(.,'http:'),' '))"/>
          </xsl:if>
          <xsl:if test="not(contains(substring-after(.,'http:'),' '))">
            <xsl:value-of select="substring-before(.,'http:')"/>
            <a href="http:{substring-after(.,'http:')}">http:<xsl:call-template name="split_string">
                <xsl:with-param name="string" select="substring-after(.,'http:')"/>
              </xsl:call-template>
            </a>
          </xsl:if>
        </xsl:when>

        <!-- Display /me ... actions in a different style -->
        <xsl:when test="starts-with(.,'*')">
          <i><xsl:value-of select="substring-after(.,'* ')"/></i>
        </xsl:when>

        <!-- For other events just copy the description from the log -->
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </xsl:template>

  <!-- Insert spaces in long strings (e.g. href) so that they wrap and
       no longer mess with the page layout. One space after each 50
       characters.-->
  <xsl:template name="split_string">
    <xsl:param name="string"></xsl:param>
    <xsl:param name="return"></xsl:param>
    <xsl:variable name="max_length" select="50"/>

    <xsl:choose>
      <xsl:when test="string-length($string) != 0">
        <xsl:choose>
          <xsl:when test="string-length($string) > $max_length">
            <xsl:call-template name="split_string">
              <xsl:with-param name="string" select="substring($string, $max_length)"/>
              <xsl:with-param name="return" select="concat($return, substring($string, 1, $max_length), ' ')"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat($return, $string)"/>
          </xsl:otherwise>
      </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$return"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
</xsl:stylesheet>
