<?xml version="1.0"?>

<queryset>
   <rdbms><type>postgresql</type><version>7.1</version></rdbms>

<fullquery name="get_latest_revision">      
      <querytext>
      
            select content_item__get_latest_revision(:comment_id) 
	
      </querytext>
</fullquery>

 
<fullquery name="get_revision_comment">      
      <querytext>
      
           select g.related_object_id as object_id,
	          g.comment_id,
	          content_item__get_live_revision(g.comment_id) as live_revision,
                  r.revision_id,
                  r.title,
	          r.content, 
	          r.mime_type, 
	          o.creation_user,
	          o.creation_date,
	          acs_object__name(o.creation_user) as author
             from general_comments g,
                  cr_revisions r,
                  acs_objects o
            where g.comment_id = o.object_id and
                  g.comment_id = r.item_id and
	          r.revision_id = :revision_id
    
      </querytext>
</fullquery>

 
<fullquery name="get_comment">      
      <querytext>
      
           select g.related_object_id as object_id,
	          g.comment_id,
	          r.revision_id as live_revision,
	          r.revision_id,
                  r.title,
	          r.content, 
	          r.mime_type, 
	          o.creation_user,
	          o.creation_date,
	          acs_object__name(o.creation_user) as author
             from general_comments g,
                  acs_objects o, 
	          cr_revisions r
            where g.comment_id = :comment_id and
                  g.comment_id = o.object_id and
                  g.comment_id = r.item_id and
	          r.revision_id = content_item__get_live_revision(:comment_id)
    
      </querytext>
</fullquery>

 
<fullquery name="get_revisions">      
      <querytext>
      
    select r.revision_id,
           to_char(o.creation_date, 'MM-DD-YY HH24:MI:SS') as revision_date
      from cr_revisions r,
           acs_objects o
     where r.item_id = :comment_id and
           o.object_id = r.revision_id
     order by o.creation_date desc

      </querytext>
</fullquery>

 
</queryset>
