#packages/general-comments/www/url-add-edit.tcl
ad_page_contract {
    @author Dave Bauer dave@thedesignexperience.org
    @author Phong Nguyen <phong@arsdigita.com>
    @author Pascal Scheffers (pascal@scheffers.net)
    @creation-date 2003-07-02

    Add a link to a comment

} {
    parent_id:integer,notnull
    attach_id:integer
    package_id:integer,optional
    {return_url ""}
} -properties {
    page_title:onevalue
    context:onevalue
    parent_id:onevalue
    target:onevalue
    label:onevalue
    url:onevalue
    parent_id:onevalue
    return_url:onevalue    
}  -validate {
    allow_link_attachments {
        set allow_links_p [ad_parameter AllowLinkAttachmentsP {general-comments} {t}]
        if { $allow_links_p != "t" } {
            ad_complain "[_ general-comments.lt_Attaching_links_to_co]"
        }
    }
}

set user_id [ad_conn user_id]
permission::require_permission -object_id $parent_id \
                               -party_id $user_id \
                               -privilege "write"

if {[exists_and_not_null attach_id]} {
    set allow_edit_p [permission::permission_p -object_id $attach_id \
		                           -party_id $user_id \
		                           -privilege "write"
		 ]
} else {
    set allow_edit_p "f"
}

ad_form -name url-add-edit -export { parent_id return_url } -form {
    attach_id:key
    {label:text {label [_ general-comments.Label]}
	{html {size 40}}
    }
    {url:text {label [_ general-comments.URL]}
	{html {size 40}}
	{help_text [_ general-comments.URL_help_text]}
    }
} -validate {
    {url
	{ [string match $url "http://*"] }
	{ [_ general_comments.validate_URL_error] }
    }
} -select_query_name {
    get_url
} -edit_data {
    # update existing extlink

    db_dml edit_url {}

    if {[empty_string_p $return_url]} {
        set return_url "view-comment?comment_id=$parent_id&[export_url_vars return_url]"
    }

    ad_returnredirect $return_url
    ad_script_abort
    
} -new_data {

    #insert new extlink

    # insert the url into database 

    set creation_ip [ad_conn peeraddr]

    set name "extlink_$attach_id"

    db_exec_plsql insert_extlink {}

    if {[empty_string_p $return_url]} {
        set return_url "view-comment?comment_id=$parent_id&[export_url_vars return_url]"
    }
    
    ad_returnredirect $return_url
    ad_script_abort
    
}

set page_title "[_ general-comments.lt_Add_url_attachment_to] #$parent_id"
set context [list [list "view-comment?comment_id=$parent_id" "[_ general-comments.Go_back_to_comment]"] "[_ general-comments.Add_url_comment]"]

ad_return_template
