# /packages/general-comments/www/comment-add.tcl

ad_page_contract {
    Displays a form for adding a commment to a page

    comment_id is optional for add
    object_id is optional for edit
    
    @author Phong Nguyen <phong@arsdigita.com>
    @author Pascal Scheffers (pascal@scheffers.net)
    @creation-date 2000-10-12
    @cvs-id $Id: comment-add-edit.tcl,v 1.4 2003/07/13 19:05:39 daveb Exp $
} { 
    comment_id:integer,optional
    { object_id "" }
    { context_id "" }
    { title "" }
    { content "" }
    { object_name "" }
    { return_url "" }
    { revision_id "" }
    { comment_mime_type "" }
} -properties {
    page_title:onevalue
    context:onevalue
    target:onevalue
    title:onevalue
    content:onevalue
    comment_mime_type:onevalue
    object_id:onevalue
    object_name:onevalue
    context_id:onevalue
    category:onevalue
    return_url:onevalue
} -validate {
    comment_id_or_object_id {
	if {![exists_and_not_null comment_id] && [empty_string_p $object_id]} {
	    ad_complain "Must specify object_id for new comment"
	}
    }
}

# check to see if the user can create comments on this object
set user_id [ad_conn user_id]
set creation_ip [ad_conn peeraddr]
# this works unless we allow the comment-add page to be included
set package_id [ad_conn package_id]
set is_live "t"

# set context_id to object_id if we are adding

# if {![ad_form_new_p -key comment_id]} {
#     permission::require_permission -object_id $comment_id \
# 	                           -party_id $user_id \
# 	                           -privilege "write"
# } else {
#     permission::require_permission -object_id $object_id \
# 	                           -party_id $user_id \
# 	                           -privilege "general_comment_create"
# }

# ad_page_contract does not set object_name to
# [acs_object_name $object_id] if object_name is passed
# in as an empty string.

#if { [empty_string_p $object_name] } {
#    set object_name [acs_object_name $object_id]
#}

ad_form -name comment -form {
    comment_id:key
    {title:text
	{label "[_ general_comments.Title]"}
	{value $title}
	{html {maxlength 200 size 50}}
    }
    {content:richtext
	{label "[_ general_comments.Comment]"}
	{value $content}
	{html {cols 80 rows 20}}
    }
    {submit:text(submit)
	{value "[_ general_comments.Proceed]"}
    }

    {object_id:text(hidden) {value $object_id}}
    {object_name:text(hidden) {value $object_name}}
    {context_id:text(hidden) {value $context_id}}
    {return_url:text(hidden) {value $return_url}}
    {comment_mime_type:text(hidden) {value $comment_mime_type}}
} -new_data {
    set comment_mime_type [template::util::richtext::get_property format $content]
    set content [template::util::richtext::get_property contents $content]
    general_comments::general_comment::create \
	-object_id $object_id \
        -comment_id $comment_id \
	-title $title \
        -content $content \
	-comment_mime_type $comment_mime_type \
	-context_id $context_id \
	-package_id $package_id \
	-is_live $is_live \
	-user_id $user_id \
	-creation_ip $creation_ip
    if {[exists_and_not_null return_url]} {
	ad_returnredirect $return_url
    } else {
	ad_returnredirect "view-comment?[export_vars comment_id]"
    }
    ad_script_abort
} -edit_request {

    db_1row get_comment ""
    
} -edit_data {
    general_comments::general_comment::edit \
        -comment_id $comment_id \
	-title $title \
	-content $content \
	-comment_mime_type $comment_mime_type \
	-is_live $is_live \
	-creation_user $user_id \
        -creation_ip $creation_ip

    if {[exists_and_not_null return_url]} {
	ad_returnredirect $return_url
    } else {
	ad_returnredirect "view-comment?[export_vars comment_id]"
    }
    ad_script_abort
}

if {[ad_form_new_p -key comment_id]} {
    set page_title "[_ general-comments.Add_a_comment_to]: $object_name"
    set context "\"[_ general-comments.Add_comment]\""
} else {
    set page_title "[_ general-comments.Edit_a_comment_to]: $object_name"
    set context "\"[_ general-comments.Edit_comment]\""
}

#set title ""
#set content ""


ad_return_template






