# packages/general-comments/lib/comments.tcl
# this includable template returns HTML formatted comments
# pass in a reference to a multirow datasource that contains the comment data
#
# @param object_id
# @param adp - optional path to adp to use for formatting
# @comments - referecnce to multirow containing the comments
# @param print_content 1 print content of comments,0 just print titles/links
# @param print_attachments (not used until I implement attachments
#
# Dave Bauer <dave@thedesignexperience.org>
# cvs-id:
#

set package_url [general_comments_package_url]
if {![exists_and_not_null return_url]} {
    set return_url [ad_return_url]
}
    set print_content_p 1

# initialize variables

if { $print_content_p == 0 } {
    set content_select ""
    set content ""
} else {
    set content_select [db_map content_select] ;# ", r.content"
}

set community_member_url [parameter::get_from_package_key -parameter CommunityMemberUrl -default "/shared/community-member" -package_key acs-kernel ]
db_multirow comments get_comments {}

if {[info exists adp]} {
    ad_return_template $adp
} else {
    ad_return template
}
