# /packages/general-comments/tcl/general-comments-procs.tcl

# daveb: removed old deprecated namespace procs
#      : deprecated "new" none namespace procs
#      : replaced with new and improved namespace procs.
#      : yes, this is a disaster!

# Porting: Moved most queries from variables to in-line 
# for the QueryExtractor, appended '_deprecated' to 
# query-names in 'ad_proc -deprecated' functions. 
# Left one duplicate with 100% identical SQL (pascal) 

ad_library {
    Utility procs for general-comments

    @author Phong Nguyen <phong@arsdigita.com>
    @author Pascal Scheffers <pascal@scheffers.net>
    @author Dave Bauer <dave@thedesignexperience.org>

    @creation-date 2000-10-12
    @cvs-id $Id: general-comments-procs.tcl,v 1.6 2004/03/12 16:57:20 andrewg Exp $
}

namespace eval general_comments {}
namespace eval general_comments::general_comment {}

ad_proc general_comments::general_comment::create {
    -object_id
    -comment_id
    -title
    -comment_mime_type
    -context_id
    {-creation_user ""}
    {-creation_ip ""}
    {-parent_id ""}
    -package_id
    -is_live
    -content
} {
    # for now
    set description $title
    
    db_transaction {
        db_exec_plsql insert_comment {}
	
        db_1row get_revision {
            select content_item__get_latest_revision(:comment_id) as revision_id
            from dual
        } 

        db_dml set_content {
            update cr_revisions
            set content = empty_blob()
            where revision_id = :revision_id
            returning content into :1
        } -blobs [list $content]

        # Grant the user sufficient permissions to 
        # created comment. This is done here to ensure that
        # a fail on permissions granting will not leave
        # the comment with incorrect permissions. 
        if {![empty_string_p $creation_id]} {
    	    permission::grant -object_id $comment_id \
                -party_id $creation_user \
                -privilege "read"

            permission::grant -object_id $comment_id \
                -party_id $creation_user \
                -privilege "write"
        }
    }
}

ad_proc -deprecated -public general_comments_get_comments {
    { -print_content_p 0 }
    { -print_attachments_p 0 }
    object_id 
    {return_url {}}
} {
    Generates a line item list of comments for the object_id.

    @param print_content_p Pass in 1 to print out content of comments.
    @param print_attachments_p Pass in 1 to print out attachments of comments, 
                               only works if print_content_p is 1. 
    @param object_id The object_id to retrieve the comments for.
    @param return_url A url for the user to return to after viewing a comment.
} {
    # parse the comments includable template inline and return the html
    # to the caller (thanks to bartt!)

    return [template::adp_parse "[acs_root_dir]/packages/general-comments/lib/comments" [list object_id $object_id print_content_p $print_content_p return_url $return_url print_attachments_p $print_attachments_p]]
    
}

ad_proc -public general_comments_create_link {
    -object_name
    { -link_text {Add a comment} }
    -context_id
     object_id 
    {return_url {}} 
} {
    Generates an html link to add a comment to an object.

    @param object_id   The object to comment on.
    @param return_url  A url for the user to return to after viewing a comment.
    @param object_name The name of the object.
    @param link_text   The text to display for the link.
    @param context_id  The context_id for the comment.
 } {
    # get the package url
     set package_url [general_comments_package_url]
    if { [empty_string_p $package_url] } {
        return ""
    }

    # initialize variables
    if { ![info exists object_name] } { set object_name [acs_object_name $object_id] }
    if { ![info exists context_id] } { set context_id $object_id }

    set html "<a href=\"${package_url}comment-add?[export_url_vars object_id object_name return_url context_id category]\">$link_text</a>"

    return $html
}

ad_proc -private general_comments_package_url {} {
    Returns a url pointing to the mounted general-comments package.
    Uses util_memoize for caching.
} {
    return [util_memoize [list general_comments_package_url_not_cached]]
}

ad_proc -private general_comments_package_url_not_cached {} {
    Returns a url pointing to the mounted general-comments package.
    Goes to the database on every invocation.
} {
#    set package_url [site_node_closest_ancestor_package general-comments]
    set package_url "comments"
    if { ![empty_string_p $package_url] } {
        return $package_url
    } else {
        # log an error message
        ns_log "Notice" "The General Comments package is not mounted."
        return ""
    }
}
