-- plpgsql functions for general-comments
-- Dave Bauer dave@thedesignexperience.org
-- 2003-05-04

create or replace function general_comment__new(
        integer,
        integer,
        integer,
        integer,
        integer,
        varchar,
        varchar,
        varchar,
        integer,
        timestamptz,
        varchar,
        varchar,
        boolean
        ) returns integer as '
declare
        p_comment_id        alias for $1;
        p_object_id         alias for $2;
        p_package_id        alias for $3;
        p_parent_id         alias for $4;
        p_context_id        alias for $5;
        p_title             alias for $6;
        p_description       alias for $7;
        p_content           alias for $8;
        p_creation_user     alias for $9;
        p_creation_date     alias for $10;
        p_creation_ip       alias for $11;
        p_mime_type         alias for $12;
        p_is_live           alias for $13;
        v_item_id           cr_items.item_id%TYPE;
        v_revision_id       cr_revisions.revision_id%TYPE;
begin
--
-- do something with p_is_live DaveB
--
        if p_comment_id is null then
                select into v_item_id acs_object_id_seq.nextval;
        else
                v_item_id := p_comment_id;
        end if;

        PERFORM content_item__new(
                ''general_comment_'' || v_item_id,
                p_parent_id,
                v_item_id,
                NULL,
                p_creation_date,
                p_creation_user,
                p_context_id,
                p_creation_ip,
                ''content_item'',
                ''general_comment'',
                p_title,
                p_description,
                null,
                p_mime_type,
                p_content,
                ''text''
                );

        select into v_revision_id latest_revision
                         from cr_items
                         where item_id=v_item_id;

        insert into general_comments
                (
                comment_id,
                related_object_id
                )
        values
                (
                v_item_id,
                p_object_id
                );

        if p_is_live then
                perform content_item__set_live_revision(v_revision_id);
        end if;

return p_comment_id;
end;' language 'plpgsql';

create or replace function general_comment__del(
                integer
                ) returns integer as '
declare
        p_comment_id alias for $1;
begin
        -- remove permssions from the object
        delete from acs_permissions where object_id=:p_comment_id;
        -- handle attachments and child comments for threaded comments?

        -- do we need to remove live_revision and latest_revision first?
        perform content_item__delete(p_comment_id);

        delete from general_comments where comment_id=:p_comment_id;

return NULL;
end;' language 'plpgsql';

-- create a new revision of a comment
create or replace function general_comment__revise(
                integer,
                varchar,
                varchar,
                varchar,
                integer,
                timestamptz,
                varchar,
                boolean
                ) returns integer as '
declare
        p_comment_id    alias for $1;
        p_title         alias for $2;
        p_content       alias for $3;
        p_mime_type     alias for $4;
        p_creation_user alias for $5;
        p_creation_date alias for $6;
        p_creation_ip   alias for $7;
        p_is_live       alias for $8;
        v_revision_id   cr_revisions.revision_id%TYPE;
begin
        v_revision_id := content_revision__new (
                p_title,
                NULL,
                current_timestamp,
                p_mime_type,
                NULL,
                p_content,
                p_comment_id,
                NULL,
                p_creation_date,
                p_creation_user,
                p_creation_ip
                );

	if p_is_live then
		perform content_item__set_live_revision (
			p_comment_id,
			v_revision_id
		);
	end if;

	return v_revision_id;
	
end;' language 'plpgsql';

