-- plsql functions for general-comments
-- Dave Bauer dave@thedesignexperience.org
-- 2003-05-04
-- Ported to Oracle by aegrumet@alum.mit.edu
-- 2004-03-12

create or replace package general_comment
is 
  function new (
    comment_id     in general_comments.comment_id%TYPE default null,
    object_id      in acs_objects.object_id%TYPE default null,
    package_id     in apm_packages.package_id%TYPE default null,
    parent_id      in cr_items.parent_id%TYPE default null,
    context_id     in acs_objects.object_id%TYPE,
    title          in cr_revisions.title%TYPE,
    description    in cr_revisions.description%TYPE,
    content        in cr_revisions.content%TYPE,
    creation_user  in acs_objects.creation_user%TYPE default null,
    creation_date  in acs_objects.creation_date%TYPE default null,
    creation_ip    in acs_objects.creation_ip%TYPE default null,
    mime_type      in cr_revisions.mime_type%TYPE default null,
    live_p         in char
  ) return general_comments.comment_id%TYPE;

  function revise (
    comment_id     in general_comments.comment_id%TYPE default null,
    title          in cr_revisions.title%TYPE,
    content        in cr_revisions.content%TYPE,
    mime_type      in cr_revisions.mime_type%TYPE,
    creation_user  in acs_objects.creation_user%TYPE default null,
    creation_date  in acs_objects.creation_date%TYPE default null,
    creation_ip    in acs_objects.creation_ip%TYPE default null,
    live_p         in char
  ) return cr_revisions.revision_id%TYPE;

  procedure del (
    comment_id     in general_comments.comment_id%TYPE default null
  );

end general_comment;
/
show errors

create or replace package body general_comment
is 
  function new (
    comment_id     in general_comments.comment_id%TYPE default null,
    object_id      in acs_objects.object_id%TYPE default null,
    package_id     in apm_packages.package_id%TYPE default null,
    parent_id      in cr_items.parent_id%TYPE default null,
    context_id     in acs_objects.object_id%TYPE,
    title          in cr_revisions.title%TYPE,
    description    in cr_revisions.description%TYPE,
    content        in cr_revisions.content%TYPE,
    creation_user  in acs_objects.creation_user%TYPE default null,
    creation_date  in acs_objects.creation_date%TYPE default null,
    creation_ip    in acs_objects.creation_ip%TYPE default null,
    mime_type      in cr_revisions.mime_type%TYPE default null,
    live_p         in char
  ) return general_comments.comment_id%TYPE
  is
    v_item_id           cr_items.item_id%TYPE;
    v_revision_id       cr_revisions.revision_id%TYPE;
  begin

    if comment_id is null then
      select acs_object_id_seq.nextval into v_item_id from dual;
    else
      v_item_id := general_comment.new.comment_id;
    end if;

    v_item_id := content_item.new(
      name => 'general_comment_' || v_item_id,
      parent_id => general_comment.new.parent_id,
      item_id => v_item_id,
      locale => NULL,
      creation_date => general_comment.new.creation_date,
      creation_user => general_comment.new.creation_user,
      context_id => general_comment.new.context_id,
      creation_ip => general_comment.new.creation_ip,
      item_subtype => 'content_item',
      content_type => 'general_comment',
      title => general_comment.new.title,
      description => general_comment.new.description,
      mime_type => general_comment.new.mime_type,
      nls_language => null,
      data => general_comment.new.content
      );

      insert into general_comments
      (
        comment_id,
        object_id
      )
      values
      (
        v_item_id,
        general_comment.new.object_id
      );

      select latest_revision into v_revision_id
      from cr_items
      where item_id = v_item_id;

      if general_comment.new.live_p = 't' then
        content_item.set_live_revision(v_revision_id);
      end if;

      return v_item_id;
  end;

  function revise (
    comment_id     in general_comments.comment_id%TYPE default null,
    title          in cr_revisions.title%TYPE,
    content        in cr_revisions.content%TYPE,
    mime_type      in cr_revisions.mime_type%TYPE,
    creation_user  in acs_objects.creation_user%TYPE default null,
    creation_date  in acs_objects.creation_date%TYPE default null,
    creation_ip    in acs_objects.creation_ip%TYPE default null,
    live_p         in char
  ) return cr_revisions.revision_id%TYPE
  is
    v_revision_id   cr_revisions.revision_id%TYPE;
  begin
    v_revision_id := content_revision.new (
       title => general_comment.revise.title,
       description => NULL,
       publish_date => sysdate,
       mime_type => general_comment.revise.mime_type,
       nls_language => NULL,
       data => general_comment.revise.content,
       item_id => general_comment.revise.comment_id,
       revision_id => NULL,
       creation_date => general_comment.revise.creation_date,
       creation_user => general_comment.revise.creation_user,
       creation_ip => general_comment.revise.creation_ip
    );

	if general_comment.revise.live_p = 't' then
      content_item.set_live_revision (
        general_comment.revise.comment_id,
        v_revision_id
      );
	end if;

	return v_revision_id;

  end;

  procedure del (
    comment_id     in general_comments.comment_id%TYPE default null
  )
  is
  begin
    -- remove permssions from the object
    delete from acs_permissions where object_id = general_comment.del.comment_id;

    -- handle attachments and child comments for threaded comments?

    -- do we need to remove live_revision and latest_revision first?
    content_item.del(general_comment.del.comment_id);

    delete from general_comments where comment_id = general_comment.del.comment_id;

  end;

end general_comment;
/
show errors

