# /packages/form-to-mail/www/form-proc.tcl
# cvs-id $Id: form-proc.tcl,v 1.2 2003/07/30 22:18:34 stevei Exp $

ad_page_contract {
    This is the main page for the form package.  
    It gets a form from the db according to the form_name passed in to the include.

    @author steve@redmonk.net
    @creation-date 2003-06-20
    @cvs-id $Id: form-proc.tcl,v 1.2 2003/07/30 22:18:34 stevei Exp $
    @return form_html html form constructed by querying the forms table

} {
    ftm:array,optional
    ftmx:array,optional
    form_id
    return_url
} -properties {
}

##########
#
# get form details
#
# populates: 
#   form__pretty_name
#   subject_prefix
#   recipient
#   sender
##########
db_1row get_form_details_query {}

set some_output ""
set email_content ""

if {![empty_string_p [array names ftm "body"]]} {
    append email_content "$ftm(body)\n\n"
}

foreach var [array names ftm] {
     ns_log Notice "$var :  $ftm($var)"
}

foreach var [array names ftmx] {
     ns_log Notice "$var :  $ftmx($var)"
     append some_output "$var :  $ftmx($var)"
     append email_content "$var :  $ftmx($var)\n"
     append some_output "<br>"
}

append some_output "Return to url: $return_url"



#ns_sendmail to from subject body ?extraheaders? ?bcc?
ns_sendmail $recipient $sender "$subject_prefix $ftm(subject)" $email_content