<?xml version="1.0"?>
<queryset>
  <fullquery name="do_insert">
    <querytext>
        select formtomail__new(
           null,
           :form_name,
           :form_pretty_name,
           :subject_prefix,
           :subject_default,
           cast(:requires_user_subject as integer),
           cast(:requires_user_comments as integer),
           :recipient,
           :sender,
           :confirm_msg,
           null,
           :user_id,
           :package_id
        )
    </querytext>
  </fullquery>
  <fullquery name="do_update">
    <querytext>
       update formtomail
          set form_name = :form_name,
              form_pretty_name = :form_pretty_name,
              subject_prefix = :subject_prefix,
              subject_default = :subject_default,
              requires_user_subject = int4(int2(:requires_user_subject)),
              requires_user_comments = int4(int2(:requires_user_comments)),
              recipient = :recipient,
              sender = :sender,
              confirm_msg = :confirm_msg
        where form_id = :form_id
    </querytext>
  </fullquery>
  <fullquery name="form_query">
    <querytext>
      select form_name,
             form_pretty_name,
             subject_prefix,
             subject_default,
             requires_user_subject,
             requires_user_comments,
             recipient,
             sender,
             confirm_msg
        from formtomail
       where form_id = :form_id
    </querytext>
  </fullquery>
</queryset> 