ad_page_contract {
    This is the main admin page for the package.  It lists all of the forms and provides links to edit them and to create new forms.

    @author steve@redmonk.net
    @creation-date 2003-06-19
    @cvs-id $Id: index.tcl,v 1.1.1.1 2003/07/30 21:09:56 stevei Exp $
    @param orderby indicates when the user clicks on a column to order by that column
    @return table_html preformatting html table constructed by querying the samplenotes table

} {
    {orderby:optional {name}}
} -properties {
    table_html
}

# is this user authorized?
permission::require_permission -object_id [ad_conn package_id] -privilege admin

# package_id
set package_id [site_node_closest_ancestor_package "acs-subsite"]

# define the columns in the table
set table_def   {
    {form_pretty_name "Pretty Name"}
    {subject_prefix "Subject Prefix"}
    {subject_default "Subject Default"}
    {requires_user_subject "Show Subject?" }
    {requires_user_comments "Show Comments?" }
    {recipient "Recipient"}
    {sender "Sender"}
    {edit "" {} {<td>\[<a href="form-edit?form_id=$form_id">Edit</a>&nbsp;|&nbsp;<a href="form-delete?form_id=$form_id">Delete</a>\]</td>}} 
}

# construct an html table from the samplenotes database table
set table_html [ad_table -Torderby $orderby form_query { *SQL* } $table_def]