ad_page_contract {
    A page that gets confirmation and then delete forms.

    @author steve@redmonk.net
    @creation-date 2003-06-21
    @cvs-id $Id: form-delete.tcl,v 1.1.1.1 2003/07/30 21:09:56 stevei Exp $
} {
    form_id:integer
    confirm_p:optional
}

set title "Delete Form?"

if {![exists_and_not_null confirm_p]} {
    # first pass, not confirmed.  Display a form for confirmation
    set form_name [db_string get_name { *SQL* }]
    set title "Confirm Delete Form: $form_name"
    template::form::create form-del-confirm
    template::element::create form-del-confirm form_id -value $form_id -widget hidden
    template::element::create form-del-confirm confirm_p -value 1 -widget hidden
    template::element::create form-del-confirm submit \
      -label "Delete Form" \
      -widget submit
} else {
    # second pass, confirmed.  Call the database to delete the record
    db_1row do_delete { *SQL* }
    ad_returnredirect "index"
    ad_script_abort
}