--
-- packages/form-to-mail/sql/postgresql/form-to-mail-table-create.sql
--
-- @author steve@redmonk.net
-- @creation-date 2003-06-19
-- @cvs-id $Id
-- 
/* Create the table.  Each constraint is named to make it easier to identify during debugging.  The form_id is identical to the object id. */ 

create table formtomail (
    form_id                 integer constraint formtomail_fk
                                references acs_objects(object_id) 
                                constraint formtomail_pk
                                primary key,
    package_id              integer
                                constraint formtomail_package_id_fk
                                references apm_packages(package_id),
    form_name               varchar(255) constraint formtomail_name_nn
                                not null,
    form_pretty_name        varchar(255) constraint formtomail_pretty_nn
                                not null,
    subject_prefix          varchar(1024),
    subject_default         varchar(1024),
    requires_user_subject   integer,
    requires_user_comments  integer,
    recipient               varchar(255),
    sender                  varchar(255),
    confirm_msg             varchar(2048)    
);

select acs_object_type__create_type (
    'formtomail',                         -- object_type
    'Form To Mail form',                  -- pretty_name
    'Form To Mail forms',                 -- pretty_plural
    'acs_object',                         -- supertype
    'formmail',                           -- table_name
    'form_id',                            -- id_column
    'form-to-mail',                       -- package_name
    'f',                                  -- abstract_p
    null,                                 -- type_extension_table
    'formmail__name'                      -- name_method
);