-- packages/form-to-mail/sql/form-to-mail-drop.sql
-- drop script
--
-- @author steve@redmonk.net
-- @creation-date 2003-06-19
-- @cvs-id $Id
-- /* This script removes from the database everything associated with our table. */ 

-- drop package, which drops all functions created with define_function_args

select drop_package('formtomail');

-- drop permissions
delete from acs_permissions where object_id in (select form_id from formtomail);

-- drop objects
create function inline_0 ()
returns integer as '
declare
    object_rec              record;
begin
    for object_rec in select object_id from acs_objects where object_type=''formtomail''
    loop
            perform acs_object__delete( object_rec.object_id );
    end loop;
    return 0;
end;' language 'plpgsql';

select inline_0();
drop function inline_0();

-- drop table
drop table formtomail;

-- drop type
select acs_object_type__drop_type(
   'formtomail',
   't'
); 