# /packages/form-to-mail/www/form.tcl
# cvs-id $Id: form.tcl,v 1.2 2003/07/30 22:19:12 stevei Exp $

ad_proc -private get_closest_pkg_id {
    pkg_key
} {
    set an_id [site_node::closest_ancestor_package -package_key $pkg_key]
    if { ![exists_and_not_null an_id] } {
        set an_id [site_node_apm_integration::get_child_package_id -package_key $pkg_key]
    }
    return $an_id
}

set return_url [ad_conn url]

################################
# There should be only one instance of form-to-mail in a subsite.
################################
set ftm_id [get_closest_pkg_id "form-to-mail"]

set package_id [site_node_closest_ancestor_package "acs-subsite"]

set closest_mount [site_node::get_url_from_object_id -object_id $ftm_id]

ns_log Notice "closest mount: $closest_mount"

set action "${closest_mount}form-proc"

db_1row get_form_query {}

ad_form -name mail_form -action $action -export { return_url form_id } -form {
    {kludge:text(hidden)
        {value "kluge since a form has to have something in it"}
    }
}

if {$requires_user_subject} {
    ad_form -extend -name mail_form -form {
        { ftm.subject:text(text)
            {label "Title:"}
            {html {size 40}}
            {value "$subject_default"}
        }
    }
} else {
    ad_form -extend -name mail_form -form {
        { ftm.subject:text(hidden)
            {value "$subject_default"}
        }
    }
}

if {$requires_user_comments} {
    ad_form -extend -name mail_form -form {
        { ftm.body:text(textarea)
            {label "Comments"}
            {html {rows 4 cols 40}}
        }
    }
}

# get the extra form data
if {[info exists extra_form_file]} {
    if { [file exists [acs_root_dir]$extra_form_file] } {
        source [acs_root_dir]$extra_form_file
    } elseif { [file exists $extra_form_file] } {
        source $extra_form_file
    }
}

ad_return_template