alter table formtomail add confirm_msg text;

select define_function_args('formtomail__new','form_id,package_id,form_name,form_pretty_name,subject_prefix,subject_default,requires_user_subject,requires_user_comments,recipient,sender,confirm_msg,creation_date,creation_user,context_id'); 

create or replace function formtomail__new(
    integer,        -- form_id
    varchar,        -- form_name
    varchar,        -- form_pretty_name
    varchar,        -- subject_prefix
    varchar,        -- subject_default
    integer,        -- requires_user_subject
    integer,        -- requires_user_comments
    varchar,        -- recipient
    varchar,        -- sender
    text,           -- confirm_msg
    timestamptz,    -- creation_date
    integer,        -- creation_user
    integer         -- context_id
) returns integer as '
declare
    p_form_id                                     alias for $1;
    p_form_name                                   alias for $2;
    p_form_pretty_name                            alias for $3;
    p_subject_prefix                              alias for $4;
    p_subject_default                             alias for $5;
    p_requires_user_subject                       alias for $6;
    p_requires_user_comments                      alias for $7;
    p_recipient                                   alias for $8;
    p_sender                                      alias for $9;
    p_confirm_msg                                 alias for $10;
    p_creation_date                               alias for $11; 
    p_creation_user                               alias for $12;
    p_context_id                                  alias for $13;
    v_formtomail_id                               int;
begin
    v_formtomail_id := acs_object__new (
            p_form_id,
            ''formtomail'',
            p_creation_date,
            p_creation_user,
            NULL,
            p_context_id
    );
    insert into formtomail ( 
        form_id, 
        package_id,
        form_name, 
        form_pretty_name, 
        subject_prefix, 
        subject_default, 
        requires_user_subject, 
        requires_user_comments, 
        recipient, 
        sender,
        confirm_msg
    ) values (
        v_formtomail_id,
        p_context_id,
        p_form_name, 
        p_form_pretty_name,
        p_subject_prefix, 
        p_subject_default, 
        p_requires_user_subject, 
        p_requires_user_comments, 
        p_recipient, 
        p_sender,
        p_confirm_msg
    );
    PERFORM acs_permission__grant_permission
    (
      v_formtomail_id,
      p_creation_user,
      ''admin''
    );
    return v_formtomail_id;
end;' language 'plpgsql'; 