<?xml version="1.0"?>
<queryset>
    <fullquery name="one_field">
        <querytext>
	    SELECT 
                   aa.attribute_id, 
                   coalesce(aa.column_name, aa.attribute_name) AS column_name, 
                   aa.default_value, 
                   coalesce(aa.table_name,at.table_name) AS table_name, 
                   aa.storage, aa.datatype, aa.sort_order, aa.attribute_name, 
                   aa.pretty_name, aa.pretty_plural
	      FROM 
                   acs_attributes aa,
	           ca_attributes ca, acs_object_types at
	     WHERE 
                   aa.attribute_id = :attribute_id
	       AND
                   aa.attribute_id = ca.attribute_id
	       AND 
                   aa.object_type = :content_type
	       AND 
                   at.object_type = :content_type
	   ORDER BY
	           sort_order
        </querytext>
    </fullquery>

    <fullquery name="delete_attribute">
        <querytext>
	    select ca_attributes__drop_attribute(:content_type, :attribute_name);
        </querytext>
    </fullquery>
</queryset>

