<?xml version="1.0"?>
<queryset>
    <fullquery name="field">
        <querytext>
	    SELECT 
                   aa.attribute_id, 
                   coalesce(aa.column_name, aa.attribute_name) AS column_name, 
                   aa.default_value, 
                   coalesce(aa.table_name,at.table_name) AS table_name, 
                   aa.storage, aa.datatype, aa.sort_order, aa.attribute_name, 
                   aa.pretty_name, aa.pretty_plural
	      FROM 
                   acs_attributes aa,
	           ca_attributes ca, acs_object_types at
	     WHERE 
                   aa.attribute_id = :attribute_id
	       AND
                   aa.attribute_id = ca.attribute_id
	       AND 
                   aa.object_type = :content_type
	       AND 
                   at.object_type = :content_type
        </querytext>
    </fullquery>

    <fullquery name="widget_vars">
	<querytext>

	    select 
	           widget, label, html_options, select_options, 
		   validate, optional_p, enabled_p
	      from 
	           ca_attribute_widget_values
	     where 
	           attribute_id=:attribute_id
		   
	</querytext>
    </fullquery>

    <fullquery name="datatypes">
	<querytext>
	
	    select distinct datatype, datatype 
	      from acs_attributes 
	  order by datatype

	</querytext>
    </fullquery>

    <fullquery name="max_sort_order">
	<querytext>
	    select max(sort_order) as sort_order from acs_attributes
	</querytext>
    </fullquery>

    <fullquery name="widgets">
	<querytext>
	
	    select widget, widget 
	      from ca_attribute_widgets 
	 order by widget

	</querytext>
    </fullquery>

    <fullquery name="attribute_update">
	<querytext>

	    update acs_attributes 
	       set pretty_name = :pretty_name, 
	           pretty_plural = :pretty_plural, 
		   sort_order = :sort_order, 
		   default_value = :default_value 
             where 
	           attribute_id = :attribute_id

	</querytext>
    </fullquery>

    <fullquery name="widget_update">
	<querytext>
	`
	    update ca_attribute_widget_values 
	       set label = :label, 
	           html_options = :html_options, 
		   select_options = :select_options, 
		   keyword_id = :keyword_id,
		   extra_options = :extra_options,
		   validate = :validate, 
		   optional_p = :optional_p, 
		   enabled_p = :enabled_p 
	     where 
	           attribute_id = :attribute_id
		   
	</querytext> 
    </fullquery>

</queryset>
