ad_page_contract {
    Add/Edit fields (attributes)

    @author Paul Doerwald (paul@liquidmedia.ca)
    @author Roberto Mello
    @creation-date 2002-10-24
} {
    attribute_id:integer,notnull,optional
    {attribute_name:nohtml ""}
    {datatype:nohtml text}
    {column_spec:nohtml ""}
    {pretty_name:nohtml ""}
    {pretty_plural:nohtml ""}
    {sort_order:nohtml ""}
    {default_value:nohtml ""}
    {widget:nohtml text}
    {label:nohtml ""}
    {keyword_id:integer 0}
    {html_options:nohtml ""}
    {select_options:nohtml ""}
    {validate ""}
    {extra_help_p:boolean t}
    {extra_help_text ""}
    {extra_format ""}
    {optional_p:boolean f}
    {enabled_p:boolean t}
} -properties {
    title:onevalue
    context:onevalue
}

set content_type "ca_ad"
set package_id [ad_conn package_id]
set indent_pattern "-"
set indent_factor 2 

#
# RBM: If the user is a site-wide admin, then we show up to the root
#      category, to allow the adding of site-wide fields. But otherwise
#      we only go up to this package's top category.
#

if {[acs_user::site_wide_admin_p]} {
	set main_category_id [classified-ads::get_main_keyword_id]
} else {
	set main_category_id [classified-ads::get_package_keyword_id]
}

template::form create new_field

if {[template::form is_request new_field] && [info exists attribute_id]} {
    template::element create new_field attribute_id \
	-widget hidden \
	-datatype integer \
	-value $attribute_id

    db_1row field { }

    set title "Edit Field"
    set context [list [list "fields" "Fields"] "Edit Field"]
    set cant_edit_html "onfocus \"blur();\" style \"background: #d3d3d3\""
    set column_spec [db_string get_column_spec {}] 

    ## Widget values
    db_0or1row widget_vars { }

} else {
    set title "Add Field"
    set context [list [list "fields" "Fields"] "Add Field"]
    set cant_edit_html ""
}

template::element create new_field attribute_name \
    -datatype text \
    -label "Attribute Name" \
    -help_text "A-Z, a-z, 0-9, - and _ only" \
    -html "size 30 $cant_edit_html" \
    -value $attribute_name

template::element create new_field pretty_name \
    -datatype text \
    -label "Pretty Name" \
    -help_text "These (with Pretty Plural) are the names you'll know this field by (see <i>Label</i>)" \
    -html "size 30" \
    -value $pretty_name

template::element create new_field pretty_plural \
    -datatype text \
    -label "Pretty Plural" \
    -html "size 30" \
    -value $pretty_plural

template::element create new_field keyword_id \
    -widget select \
    -datatype integer \
    -label "Category" \
    -help_text "The category to which this new field will belong to. A category of name \"classified-ads-package-xxx\" means the main category for this package instance, and the field will be available to all its subcategories." \
    -options [classified-ads::categories::get_all_tree -keyword_id $main_category_id] \
    -value $keyword_id
    
template::element create new_field datatype \
    -widget select \
    -datatype text \
    -label "Datatype" \
    -html $cant_edit_html \
    -help_text "The kind of value you want" \
    -options [db_list_of_lists datatypes { }] \
    -value $datatype

template::element create new_field column_spec \
    -datatype text \
    -label "Column Spec" \
    -html $cant_edit_html \
    -help_text "The SQL data type of the column you want created in the database.  Value in <i>column spec</i> <b>must</b> agree with value in <i>datatype</i>.  <i>e.g.</i> <code>integer</code>, <code>varchar(100)</code>, <code>timestamp</code>, <code>numeric(9,2)</code>, etc." \
    -value $column_spec

if { $sort_order == "" } {
    db_1row max_sort_order { }
    set sort_order [expr $sort_order + 1]
}

template::element create new_field sort_order \
    -datatype integer \
    -label "Sort Order" \
    -html "size 5" \
    -help_text "The order in the form (top-to-bottom) you want this field displayed in." \
    -value $sort_order

template::element create new_field default_value \
    -datatype text \
    -label "Default Value" \
    -html "size 30" \
    -help_text "If the user enters no value, this will be used as default." \
    -value $default_value

template::element create new_field widget \
    -widget select \
    -datatype text \
    -label "Widget" \
    -help_text "How would you like the data entry field displayed?" \
    -html $cant_edit_html \
    -options [db_list_of_lists widgets { }] \
    -value $widget

template::element create new_field label \
    -datatype text \
    -label "Label" \
    -html {size 30} \
    -help_text "This is the word that appears beside the field on the <i>place ad</i> form shown to users." \
    -value $label

template::element create new_field html_options \
    -datatype text \
    -label "HTML Options" \
    -html {size 30} \
    -help_text "For additional HTML attributes for the widget.  Always surround with {braces} and always in <i>attribute value</i> order.  <i>e.g.</i> <code>{size 30 maxlength 100 onfocus \"blur();\"}</code>" \
    -value $html_options

template::element create new_field select_options \
    -datatype text \
    -label "Select Options" \
    -html {size 30} \
    -optional \
    -help_text "A list of options for select lists and button groups (check boxes or radio buttons). The list contains two-element lists in the form <code>{ {label value} {label value} {label value} ...}</code> <i>e.g.</i> <code>{{S \"12.99\"} {M \"15.49\"} {L \"17.99\"}}</code> renders in HTML:<pre>
    &lt;option value=\"12.99\"&gt;S
    &lt;option value=\"15.49\"&gt;M
    &lt;option value=\"17.99\"&gt;L
    </pre>" \
    -value $select_options

template::element create new_field extra_format \
    -widget select \
    -datatype text \
    -label "Format for Dates" \
    -help_text "If the datatype is \"date\", this is the order of the date fields that will be shown to the user." \
    -options {{"Month/Day/Year" "MONTH DD YYYY"} {"Day/Month/Year" "DD MONTH YYYY"} {"Year/Month/Day" "YYYY MONTH DD"} {"Year/Day/Month" "YYYY DD MONTH"}} \
    -value $extra_format
    
template::element create new_field extra_help_text \
    -datatype text \
    -label "Help Text" \
    -html {size 30} \
    -optional \
    -help_text "Whatever you enter here will be shown to the user under the field. Use it to give helpful hints to the user about what he should enter." \
    -value $extra_help_text
    
template::element create new_field validate \
    -datatype text \
    -label "Validate" \
    -optional \
    -html {size 30} \
    -help_text "<i>(experts only)</i> &mdash; A list of custom validation blocks in the form <code>{ name { expression } { message } name { expression } { message } ...}</code> where name is a unique identifier for the validation step, expression is a block to Tcl code that evaluates to 1 or 0, and message is to be displayed to the user when the validation step fails. Use the special variable <tt>\$value</tt> to refer to the value entered by the user in that field." \
    -value $validate

template::element create new_field extra_help_p \
    -datatype boolean \
    -widget checkbox \
    -options {{"Show Date Help" t}} \
    -label " " \
    -optional \
    -help_text "If the field is of datatype \"date\" and this is checked, the month, day, year fields will be labeled." \
    -value $extra_help_p
    
template::element create new_field optional_p \
    -datatype boolean \
    -widget checkbox \
    -label " " \
    -options {{Optional t}} \
    -help_text "If checked, the user won't be required to use this field." \
    -value $optional_p

template::element create new_field enabled_p \
    -datatype boolean \
    -widget checkbox \
    -label " " \
    -help_text "If checked, this field will appear to the user." \
    -options {{Enabled t}} \
    -value $enabled_p

if [template::form is_valid new_field] {
    set user_id [ad_conn user_id]
    set peeraddr [ad_conn peeraddr]
    set extra_options ""
    
    if {[string match $datatype "date"]} {
        if {![empty_string_p $extra_help_p]} { 
            append extra_options " -help"
	}

        if {![empty_string_p $extra_format]} { 
            append extra_options " -format $extra_format"
	}
    }

    if {![empty_string_p $extra_help_text]} {
        append extra_options " -help_text \""
        append extra_options $extra_help_text
        append extra_options "\"" 
    }

    if [info exists attribute_id] {
	db_transaction {
	    db_dml attribute_update { }
	    db_dml widget_update { }
	}
    } else {
	db_transaction {
	    db_1row attribute_new { }
	    db_1row widget_new { }
	}
	util_memoize_flush "classified-ads::categories::get_custom_fields -keyword_id $keyword_id"
    }
    ad_returnredirect "fields"
}

ad_return_template

